/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.jsoup.select;

import com.android.layoutlib.jsoup.nodes.Node;
import com.android.layoutlib.jsoup.select.NodeVisitor;

public class NodeTraversor {
    private NodeVisitor visitor;

    public NodeTraversor(NodeVisitor visitor) {
        this.visitor = visitor;
    }

    public void traverse(Node root) {
        Node node = root;
        int depth = 0;
        while (node != null) {
            this.visitor.head(node, depth);
            if (node.childNodes().size() > 0) {
                node = node.childNode(0);
                ++depth;
                continue;
            }
            while (node.nextSibling() == null && depth > 0) {
                this.visitor.tail(node, depth);
                node = node.parent();
                --depth;
            }
            this.visitor.tail(node, depth);
            if (node == root) break;
            node = node.nextSibling();
        }
    }
}

