/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.app.WindowConfiguration;
import android.content.Context;
import android.graphics.Insets;
import android.graphics.Rect;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.InsetsFrameProvider;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.bars.Config;
import com.android.layoutlib.bridge.bars.CustomBar;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.Density;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class StatusBar
extends CustomBar {
    private static final String ATTR_COLOR = "statusBarColor";
    public static final String ATTR_TRANSLUCENT = "windowTranslucentStatus";
    private DisplayCutout mDisplayCutout;
    private int mStatusBarHeight;

    public StatusBar(BridgeContext context, Density density, boolean isRtl, boolean rtlEnabled, boolean isEdgeToEdge, int simulatedPlatformVersion) {
        super(context, 0, "status_bar.xml", simulatedPlatformVersion);
        boolean isLightTheme;
        int color2;
        this.setGravity(8388663);
        int backgroundColor = isEdgeToEdge ? 0 : ((color2 = this.getBarColor(ATTR_COLOR, ATTR_TRANSLUCENT)) == 0 ? Config.getStatusBarColor(simulatedPlatformVersion) : color2);
        this.setBackgroundColor(backgroundColor);
        ArrayList<ImageView> icons = new ArrayList<ImageView>(2);
        TextView clockView = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child instanceof ImageView) {
                icons.add((ImageView)child);
                continue;
            }
            if (!(child instanceof TextView)) continue;
            clockView = (TextView)child;
        }
        if (icons.size() != 2 || clockView == null) {
            Bridge.getLog().error("broken", "Unable to initialize statusbar", null, null, null);
            return;
        }
        int foregroundColor = isEdgeToEdge ? ((isLightTheme = ResourceHelper.getBooleanThemeFrameworkAttrValue(context.getRenderResources(), "isLightTheme", false)) ? -1728053248 : -1) : this.getForegroundColor(simulatedPlatformVersion);
        this.loadIcon((ImageView)icons.get(0), "stat_sys_wifi_signal_4_fully." + Config.getWifiIconType(simulatedPlatformVersion), density, foregroundColor);
        this.loadIcon((ImageView)icons.get(1), "stat_sys_battery_100.png", density, foregroundColor);
        clockView.setText(Config.getTime(simulatedPlatformVersion));
        clockView.setTextColor(foregroundColor);
    }

    private int getForegroundColor(int platformVersion) {
        if (Config.isGreaterOrEqual(platformVersion, 23)) {
            RenderResources renderResources = this.getContext().getRenderResources();
            boolean translucentBackground = ResourceHelper.getBooleanThemeFrameworkAttrValue(renderResources, ATTR_TRANSLUCENT, false);
            if (translucentBackground) {
                return -1;
            }
            boolean drawnByWindow = ResourceHelper.getBooleanThemeFrameworkAttrValue(renderResources, "windowDrawsSystemBarBackgrounds", false);
            if (drawnByWindow) {
                boolean lightStatusBar = ResourceHelper.getBooleanThemeFrameworkAttrValue(renderResources, "windowLightStatusBar", false);
                return lightStatusBar ? -1728053248 : -1;
            }
            return -1;
        }
        return Config.getTimeColor(platformVersion);
    }

    @Override
    protected TextView getStyleableTextView() {
        return null;
    }

    public WindowManager.LayoutParams getBarLayoutParams() {
        return this.getBarLayoutParamsForRotation(this.mContext.getDisplay().getRotation());
    }

    private WindowManager.LayoutParams getBarLayoutParamsForRotation(int rotation) {
        int height = StatusBar.getStatusBarHeightForRotation(this.mContext, rotation);
        WindowManager.LayoutParams lp = StatusBar.createWindowParams(height);
        InsetsFrameProvider gestureInsetsProvider = new InsetsFrameProvider(this, 0, WindowInsets.Type.mandatorySystemGestures());
        int safeTouchRegionHeight = this.mContext.getResources().getDimensionPixelSize(17105276);
        if (safeTouchRegionHeight > 0) {
            gestureInsetsProvider.setMinimalInsetsSizeInDisplayCutoutSafe(Insets.of(0, safeTouchRegionHeight, 0, 0));
        }
        lp.providedInsets = new InsetsFrameProvider[]{new InsetsFrameProvider(this, 0, WindowInsets.Type.statusBars()).setInsetsSize(StatusBar.getInsets(height)), new InsetsFrameProvider(this, 0, WindowInsets.Type.tappableElement()).setInsetsSize(StatusBar.getInsets(height)), gestureInsetsProvider};
        return lp;
    }

    private static int getStatusBarHeightForRotation(Context context, int targetRot) {
        Insets waterfallInsets;
        Insets insets;
        Display display = context.getDisplay();
        DisplayCutout cutout = display.getCutout();
        DisplayInfo info = new DisplayInfo();
        display.getDisplayInfo(info);
        if (cutout == null) {
            insets = Insets.NONE;
            waterfallInsets = Insets.NONE;
        } else {
            DisplayCutout rotated = cutout.getRotated(info.logicalWidth, info.logicalHeight, info.rotation, targetRot);
            insets = Insets.of(rotated.getSafeInsets());
            waterfallInsets = rotated.getWaterfallInsets();
        }
        int defaultSize = context.getResources().getDimensionPixelSize(17105765);
        return Math.max(insets.top, defaultSize + waterfallInsets.top);
    }

    private static WindowManager.LayoutParams createWindowParams(int height) {
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(-1, height, 2000, -2139095032, -3);
        lp.privateFlags |= 0x1000000;
        lp.gravity = 48;
        lp.layoutInDisplayCutoutMode = 3;
        return lp;
    }

    private static Insets getInsets(int height) {
        return Insets.of(0, height, 0, 0);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Display display = this.getDisplay();
        DisplayInfo info = new DisplayInfo();
        display.getDisplayInfo(info);
        this.mDisplayCutout = info.displayCutout;
        if (this.mDisplayCutout != null) {
            this.updateStatusBarHeight();
            this.updateSafeInsets();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mDisplayCutout = null;
    }

    private void updateStatusBarHeight() {
        int waterfallTopInset = this.mDisplayCutout == null ? 0 : this.mDisplayCutout.getWaterfallInsets().top;
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        this.mStatusBarHeight = StatusBar.getStatusBarHeightForRotation(this.mContext, this.mContext.getDisplay().getRotation());
        layoutParams.height = this.mStatusBarHeight - waterfallTopInset;
        this.setLayoutParams(layoutParams);
    }

    private void updateSafeInsets() {
        Insets insets = this.getStatusBarContentInsets();
        this.setPadding(insets.left, insets.top, insets.right, this.getPaddingBottom());
    }

    private Insets getStatusBarContentInsets() {
        WindowConfiguration windowConfiguration = this.getContext().getResources().getConfiguration().windowConfiguration;
        Rect screenBounds = windowConfiguration.getMaxBounds();
        List<Rect> cutoutRects = Stream.of(this.mDisplayCutout.getBoundingRectLeft(), this.mDisplayCutout.getBoundingRectRight(), this.mDisplayCutout.getBoundingRectTop()).filter(rect -> !rect.isEmpty()).toList();
        if (cutoutRects.isEmpty()) {
            return Insets.NONE;
        }
        int leftMargin = 0;
        int rightMargin = 0;
        int width = screenBounds.width();
        Rect sbRect = new Rect(0, 0, width, this.mStatusBarHeight);
        for (Rect cutoutRect : cutoutRects) {
            Rect shortEdge = windowConfiguration.getRotation() == 1 ? new Rect(cutoutRect.left, 0, cutoutRect.right, screenBounds.height()) : new Rect(0, cutoutRect.top, width, cutoutRect.bottom);
            if (!sbRect.intersect(shortEdge)) continue;
            if (cutoutRect.left == 0) {
                leftMargin = Math.max(leftMargin, cutoutRect.width());
                continue;
            }
            if (cutoutRect.right != width) continue;
            rightMargin = Math.max(rightMargin, cutoutRect.width());
        }
        return Insets.of(leftMargin, 0, rightMargin, 0);
    }
}

