/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.utilities.easing;

public class SpringStopEngine {
    double mDamping = 0.5;
    private static final double UNSET = Double.MAX_VALUE;
    private boolean mInitialized = false;
    private double mStiffness;
    private double mTargetPos;
    private double mLastVelocity;
    private float mLastTime;
    private float mPos;
    private float mV;
    private float mMass;
    private float mStopThreshold;
    private int mBoundaryMode = 0;

    void log(String str) {
        StackTraceElement s = new Throwable().getStackTrace()[1];
        String line = ".(" + s.getFileName() + ":" + s.getLineNumber() + ") " + s.getMethodName() + "() ";
        System.out.println(line + str);
    }

    public SpringStopEngine() {
    }

    public float getTargetValue() {
        return (float)this.mTargetPos;
    }

    public void setInitialValue(float v) {
        this.mPos = v;
    }

    public void setTargetValue(float v) {
        this.mTargetPos = v;
    }

    public SpringStopEngine(float[] parameters) {
        if (parameters[0] != 0.0f) {
            throw new RuntimeException(" parameter[0] should be 0");
        }
        this.springParameters(1.0f, parameters[1], parameters[2], parameters[3], Float.floatToRawIntBits(parameters[4]));
    }

    public void springStart(float currentPos, float target, float currentVelocity) {
        this.mTargetPos = target;
        this.mInitialized = false;
        this.mPos = currentPos;
        this.mLastVelocity = currentVelocity;
        this.mLastTime = 0.0f;
    }

    public void springParameters(float mass, float stiffness, float damping, float stopThreshold, int boundaryMode) {
        this.mDamping = damping;
        this.mInitialized = false;
        this.mStiffness = stiffness;
        this.mMass = mass;
        this.mStopThreshold = stopThreshold;
        this.mBoundaryMode = boundaryMode;
        this.mLastTime = 0.0f;
    }

    public float getVelocity(float time) {
        return this.mV;
    }

    public float get(float time) {
        this.compute(time - this.mLastTime);
        this.mLastTime = time;
        if (this.isStopped()) {
            this.mPos = (float)this.mTargetPos;
        }
        return this.mPos;
    }

    public float getAcceleration() {
        double k = this.mStiffness;
        double c = this.mDamping;
        double x = (double)this.mPos - this.mTargetPos;
        return (float)(-k * x - c * (double)this.mV) / this.mMass;
    }

    public float getVelocity() {
        return 0.0f;
    }

    public boolean isStopped() {
        double v = this.mV;
        double m = this.mMass;
        double k = this.mStiffness;
        double x = (double)this.mPos - this.mTargetPos;
        double energy = v * v * m + k * x * x;
        double max_def = Math.sqrt(energy / k);
        return max_def <= (double)this.mStopThreshold;
    }

    private void compute(double dt) {
        if (dt <= 0.0) {
            return;
        }
        double k = this.mStiffness;
        double c = this.mDamping;
        int overSample = (int)(1.0 + 9.0 / (Math.sqrt(this.mStiffness / (double)this.mMass) * dt * 4.0));
        dt /= (double)overSample;
        for (int i = 0; i < overSample; ++i) {
            double x = (double)this.mPos - this.mTargetPos;
            double a = (-k * x - c * (double)this.mV) / (double)this.mMass;
            double avgV = (double)this.mV + a * dt / 2.0;
            double avgX = (double)this.mPos + dt * avgV / 2.0 - this.mTargetPos;
            a = (-avgX * k - avgV * c) / (double)this.mMass;
            double dv = a * dt;
            avgV = (double)this.mV + dv / 2.0;
            this.mV += (float)dv;
            this.mPos += (float)(avgV * dt);
            if (this.mBoundaryMode <= 0) continue;
            if (this.mPos < 0.0f && (this.mBoundaryMode & 1) == 1) {
                this.mPos = -this.mPos;
                this.mV = -this.mV;
            }
            if (!(this.mPos > 1.0f) || (this.mBoundaryMode & 2) != 2) continue;
            this.mPos = 2.0f - this.mPos;
            this.mV = -this.mV;
        }
    }
}

