/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.utilities;

import java.util.Arrays;

public class IntIntMap {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int NOT_PRESENT = Integer.MIN_VALUE;
    private int[] mKeys = new int[16];
    private int[] mValues;
    int mSize;

    public IntIntMap() {
        Arrays.fill(this.mKeys, Integer.MIN_VALUE);
        this.mValues = new int[16];
    }

    public void clear() {
        Arrays.fill(this.mKeys, Integer.MIN_VALUE);
        Arrays.fill(this.mValues, 0);
        this.mSize = 0;
    }

    public boolean contains(int key) {
        return this.findKey(key) != -1;
    }

    public int put(int key, int value) {
        if (key == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Key cannot be NOT_PRESENT");
        }
        if ((float)this.mSize > (float)this.mKeys.length * 0.75f) {
            this.resize();
        }
        return this.insert(key, value);
    }

    public int get(int key) {
        int index = this.findKey(key);
        if (index == -1) {
            return 0;
        }
        return this.mValues[index];
    }

    public int size() {
        return this.mSize;
    }

    private int insert(int key, int value) {
        int index = this.hash(key) % this.mKeys.length;
        while (this.mKeys[index] != Integer.MIN_VALUE && this.mKeys[index] != key) {
            index = (index + 1) % this.mKeys.length;
        }
        int oldValue = 0;
        if (this.mKeys[index] == Integer.MIN_VALUE) {
            ++this.mSize;
        } else {
            oldValue = this.mValues[index];
        }
        this.mKeys[index] = key;
        this.mValues[index] = value;
        return oldValue;
    }

    private int findKey(int key) {
        int index = this.hash(key) % this.mKeys.length;
        while (this.mKeys[index] != Integer.MIN_VALUE) {
            if (this.mKeys[index] == key) {
                return index;
            }
            index = (index + 1) % this.mKeys.length;
        }
        return -1;
    }

    private int hash(int key) {
        return key;
    }

    private void resize() {
        int i;
        int[] oldKeys = this.mKeys;
        int[] oldValues = this.mValues;
        this.mKeys = new int[oldKeys.length * 2];
        for (i = 0; i < this.mKeys.length; ++i) {
            this.mKeys[i] = Integer.MIN_VALUE;
        }
        this.mValues = new int[oldKeys.length * 2];
        this.mSize = 0;
        for (i = 0; i < oldKeys.length; ++i) {
            if (oldKeys[i] == Integer.MIN_VALUE) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }
}

