/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.DimensionModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.WidthInModifierOperation;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class WidthModifierOperation
extends DimensionModifierOperation {
    private static final int OP_CODE = 16;
    public static final String CLASS_NAME = "WidthModifierOperation";
    private WidthInModifierOperation mWidthIn = null;

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 16;
    }

    public static void apply(@NonNull WireBuffer buffer, int type, float value) {
        buffer.start(16);
        buffer.writeInt(type);
        buffer.writeFloat(value);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        DimensionModifierOperation.Type type = DimensionModifierOperation.Type.fromInt(buffer.readInt());
        float value = buffer.readFloat();
        WidthModifierOperation op = new WidthModifierOperation(type, value);
        operations.add(op);
    }

    public WidthModifierOperation(@NonNull DimensionModifierOperation.Type type, float value) {
        super(type, value);
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        WidthModifierOperation.apply(buffer, this.mType.ordinal(), this.mValue);
    }

    public WidthModifierOperation(@NonNull DimensionModifierOperation.Type type) {
        super(type);
    }

    public WidthModifierOperation(float value) {
        super(value);
    }

    @Override
    @NonNull
    public String toString() {
        return "Width(" + (Object)((Object)this.mType) + ", " + this.mValue + ")";
    }

    @Override
    @NonNull
    public String serializedName() {
        return "WIDTH";
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Modifier Operations", 16, CLASS_NAME).description("define the animation").field(0, "type", "").field(1, "value", "");
    }

    public void setWidthIn(WidthInModifierOperation widthInConstraints) {
        this.mWidthIn = widthInConstraints;
    }

    public WidthInModifierOperation getWidthIn() {
        return this.mWidthIn;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType(CLASS_NAME).add("width", this.mValue, this.mOutValue).add("dimensionModifierType", this.mType);
    }
}

