/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.DecoratorComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.List;

public class ComponentVisibilityOperation
extends Operation
implements ModifierOperation,
VariableSupport,
DecoratorComponent {
    private static final int OP_CODE = 211;
    int mVisibilityId;
    int mVisibility = 1;
    private LayoutComponent mParent;

    public ComponentVisibilityOperation(int id2) {
        this.mVisibilityId = id2;
    }

    @NonNull
    public String toString() {
        return "ComponentVisibilityOperation(" + this.mVisibilityId + ")";
    }

    @NonNull
    public String serializedName() {
        return "COMPONENT_VISIBILITY";
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, this.serializedName() + " = " + this.mVisibilityId);
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return (indent != null ? indent : "") + this.toString();
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
    }

    public static void apply(@NonNull WireBuffer buffer, int valueId) {
        buffer.start(211);
        buffer.writeInt(valueId);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int valueId = buffer.readInt();
        operations.add(new ComponentVisibilityOperation(valueId));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", 211, "ComponentVisibility").description("This operation allows setting a componentvisibility from a provided value").field(0, "VALUE_ID", "Value ID representing the visibility");
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        context.listensTo(this.mVisibilityId, this);
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        int visibility = context.getInteger(this.mVisibilityId);
        this.mVisibility = Component.Visibility.isVisible(visibility) ? 1 : (Component.Visibility.isGone(visibility) ? 0 : (Component.Visibility.isInvisible(visibility) ? 2 : 0));
        if (this.mParent != null) {
            this.mParent.setVisibility(this.mVisibility);
        }
    }

    public void setParent(@Nullable LayoutComponent parent) {
        this.mParent = parent;
    }

    @Override
    public void layout(@NonNull RemoteContext context, Component component, float width, float height) {
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType("ComponentVisibilityOperation").add("visibilityId", this.mVisibilityId).add("visibility", Component.Visibility.toString(this.mVisibility));
    }
}

