/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.CoreDocument;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.SerializableToString;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.operations.MatrixRestore;
import com.android.internal.widget.remotecompose.core.operations.MatrixSave;
import com.android.internal.widget.remotecompose.core.operations.layout.ClickHandler;
import com.android.internal.widget.remotecompose.core.operations.layout.ClickModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.DecoratorComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.TouchHandler;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.PaddingModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ScrollModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import com.android.internal.widget.remotecompose.core.serialize.SerializeTags;
import java.util.ArrayList;

public class ComponentModifiers
extends PaintOperation
implements DecoratorComponent,
ClickHandler,
TouchHandler,
SerializableToString,
Serializable {
    @NonNull
    ArrayList<ModifierOperation> mList = new ArrayList();

    @NonNull
    public ArrayList<ModifierOperation> getList() {
        return this.mList;
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        super.apply(context);
        for (ModifierOperation op : this.mList) {
            op.apply(context);
            context.incrementOpCount();
        }
    }

    @NonNull
    public String toString() {
        String str = "ComponentModifiers \n";
        for (ModifierOperation modifierOperation : this.mList) {
            str = str + "    " + modifierOperation.toString() + "\n";
        }
        return str;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, "MODIFIERS");
        for (ModifierOperation m : this.mList) {
            m.serializeToString(indent + 1, serializer);
        }
    }

    public void add(@NonNull ModifierOperation operation) {
        this.mList.add(operation);
    }

    public int size() {
        return this.mList.size();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        float tx = 0.0f;
        float ty = 0.0f;
        for (ModifierOperation op : this.mList) {
            if (op.isDirty() && op instanceof VariableSupport) {
                ((VariableSupport)((Object)op)).updateVariables(context.getContext());
                op.markNotDirty();
            }
            if (op instanceof PaddingModifierOperation) {
                PaddingModifierOperation pop = (PaddingModifierOperation)op;
                context.translate(pop.getLeft(), pop.getTop());
                tx += pop.getLeft();
                ty += pop.getTop();
            }
            if (op instanceof MatrixSave || op instanceof MatrixRestore) continue;
            if (op instanceof ClickModifierOperation) {
                context.translate(-tx, -ty);
                ((ClickModifierOperation)op).paint(context);
                context.translate(tx, ty);
                continue;
            }
            if (!(op instanceof PaintOperation)) continue;
            ((PaintOperation)((Object)op)).paint(context);
        }
        context.translate(-tx, -ty);
    }

    @Override
    public void layout(@NonNull RemoteContext context, Component component, float width, float height) {
        float w = width;
        float h = height;
        for (ModifierOperation op : this.mList) {
            if (op instanceof PaddingModifierOperation) {
                PaddingModifierOperation pop = (PaddingModifierOperation)op;
                w -= pop.getLeft() + pop.getRight();
                h -= pop.getTop() + pop.getBottom();
            }
            if (op instanceof ClickModifierOperation) {
                ((DecoratorComponent)((Object)op)).layout(context, component, width, height);
                continue;
            }
            if (!(op instanceof DecoratorComponent)) continue;
            ((DecoratorComponent)((Object)op)).layout(context, component, w, h);
        }
    }

    public void addAll(@NonNull ArrayList<ModifierOperation> operations) {
        this.mList.addAll(operations);
    }

    @Override
    public void onClick(@NonNull RemoteContext context, @NonNull CoreDocument document, @NonNull Component component, float x, float y) {
        for (ModifierOperation op : this.mList) {
            if (!(op instanceof ClickHandler)) continue;
            ((ClickHandler)((Object)op)).onClick(context, document, component, x, y);
        }
    }

    @Override
    public void onTouchDown(RemoteContext context, CoreDocument document, Component component, float x, float y) {
        for (ModifierOperation op : this.mList) {
            if (!(op instanceof TouchHandler)) continue;
            ((TouchHandler)((Object)op)).onTouchDown(context, document, component, x, y);
        }
    }

    @Override
    public void onTouchUp(RemoteContext context, CoreDocument document, Component component, float x, float y, float dx, float dy) {
        for (ModifierOperation op : this.mList) {
            if (!(op instanceof TouchHandler)) continue;
            ((TouchHandler)((Object)op)).onTouchUp(context, document, component, x, y, dx, dy);
        }
    }

    @Override
    public void onTouchCancel(RemoteContext context, CoreDocument document, Component component, float x, float y) {
        for (ModifierOperation op : this.mList) {
            if (!(op instanceof TouchHandler)) continue;
            ((TouchHandler)((Object)op)).onTouchCancel(context, document, component, x, y);
        }
    }

    @Override
    public void onTouchDrag(RemoteContext context, CoreDocument document, Component component, float x, float y) {
        for (ModifierOperation op : this.mList) {
            if (!(op instanceof TouchHandler)) continue;
            ((TouchHandler)((Object)op)).onTouchDrag(context, document, component, x, y);
        }
    }

    public boolean hasHorizontalScroll() {
        for (ModifierOperation op : this.mList) {
            ScrollModifierOperation scrollModifier;
            if (!(op instanceof ScrollModifierOperation) || !(scrollModifier = (ScrollModifierOperation)op).isHorizontalScroll()) continue;
            return true;
        }
        return false;
    }

    public boolean hasVerticalScroll() {
        for (ModifierOperation op : this.mList) {
            ScrollModifierOperation scrollModifier;
            if (!(op instanceof ScrollModifierOperation) || !(scrollModifier = (ScrollModifierOperation)op).isVerticalScroll()) continue;
            return true;
        }
        return false;
    }

    public void setHorizontalScrollDimension(float hostDimension, float contentDimension) {
        for (ModifierOperation op : this.mList) {
            ScrollModifierOperation scrollModifier;
            if (!(op instanceof ScrollModifierOperation) || !(scrollModifier = (ScrollModifierOperation)op).isHorizontalScroll()) continue;
            scrollModifier.setHorizontalScrollDimension(hostDimension, contentDimension);
        }
    }

    public void setVerticalScrollDimension(float hostDimension, float contentDimension) {
        for (ModifierOperation op : this.mList) {
            ScrollModifierOperation scrollModifier;
            if (!(op instanceof ScrollModifierOperation) || !(scrollModifier = (ScrollModifierOperation)op).isVerticalScroll()) continue;
            scrollModifier.setVerticalScrollDimension(hostDimension, contentDimension);
        }
    }

    public float getHorizontalScrollDimension() {
        for (ModifierOperation op : this.mList) {
            ScrollModifierOperation scrollModifier;
            if (!(op instanceof ScrollModifierOperation) || !(scrollModifier = (ScrollModifierOperation)op).isHorizontalScroll()) continue;
            return scrollModifier.getContentDimension();
        }
        return 0.0f;
    }

    public float getVerticalScrollDimension() {
        for (ModifierOperation op : this.mList) {
            ScrollModifierOperation scrollModifier;
            if (!(op instanceof ScrollModifierOperation) || !(scrollModifier = (ScrollModifierOperation)op).isVerticalScroll()) continue;
            return scrollModifier.getContentDimension();
        }
        return 0.0f;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addTags(SerializeTags.MODIFIER).addType("ComponentModifiers").add("modifiers", this.mList);
    }
}

