/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.measure;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;

public class ComponentMeasure {
    int mId = -1;
    float mX;
    float mY;
    float mW;
    float mH;
    int mVisibility = 1;

    public void setX(float value) {
        this.mX = value;
    }

    public void setY(float value) {
        this.mY = value;
    }

    public void setW(float value) {
        this.mW = value;
    }

    public void setH(float value) {
        this.mH = value;
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public float getW() {
        return this.mW;
    }

    public float getH() {
        return this.mH;
    }

    public int getVisibility() {
        return this.mVisibility;
    }

    public void setVisibility(int visibility) {
        this.mVisibility = visibility;
    }

    public ComponentMeasure(int id2, float x, float y, float w, float h, int visibility) {
        this.mId = id2;
        this.mX = x;
        this.mY = y;
        this.mW = w;
        this.mH = h;
        this.mVisibility = visibility;
    }

    public ComponentMeasure(int id2, float x, float y, float w, float h) {
        this(id2, x, y, w, h, 1);
    }

    public ComponentMeasure(@NonNull Component component) {
        this(component.getComponentId(), component.getX(), component.getY(), component.getWidth(), component.getHeight(), component.mVisibility);
    }

    public void copyFrom(@NonNull ComponentMeasure m) {
        this.mX = m.mX;
        this.mY = m.mY;
        this.mW = m.mW;
        this.mH = m.mH;
        this.mVisibility = m.mVisibility;
    }

    public boolean same(@NonNull ComponentMeasure m) {
        return this.mX == m.mX && this.mY == m.mY && this.mW == m.mW && this.mH == m.mH && this.mVisibility == m.mVisibility;
    }

    public boolean isGone() {
        return Component.Visibility.isGone(this.mVisibility);
    }

    public boolean isVisible() {
        return Component.Visibility.isVisible(this.mVisibility);
    }

    public boolean isInvisible() {
        return Component.Visibility.isInvisible(this.mVisibility);
    }

    public void clearVisibilityOverride() {
        this.mVisibility = Component.Visibility.clearOverride(this.mVisibility);
    }

    public void addVisibilityOverride(int value) {
        this.mVisibility = Component.Visibility.clearOverride(this.mVisibility);
        this.mVisibility = Component.Visibility.add(this.mVisibility, value);
    }
}

