/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.managers;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.LayoutManager;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.ComponentMeasure;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.MeasurePass;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.Size;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ScrollModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.WidthInModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.utils.DebugLog;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class RowLayout
extends LayoutManager {
    public static final int START = 1;
    public static final int CENTER = 2;
    public static final int END = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    public static final int SPACE_BETWEEN = 6;
    public static final int SPACE_EVENLY = 7;
    public static final int SPACE_AROUND = 8;
    int mHorizontalPositioning;
    int mVerticalPositioning;
    float mSpacedBy = 0.0f;

    public RowLayout(@Nullable Component parent, int componentId, int animationId, float x, float y, float width, float height, int horizontalPositioning, int verticalPositioning, float spacedBy) {
        super(parent, componentId, animationId, x, y, width, height);
        this.mHorizontalPositioning = horizontalPositioning;
        this.mVerticalPositioning = verticalPositioning;
        this.mSpacedBy = spacedBy;
    }

    public RowLayout(@Nullable Component parent, int componentId, int animationId, int horizontalPositioning, int verticalPositioning, float spacedBy) {
        this(parent, componentId, animationId, 0.0f, 0.0f, 0.0f, 0.0f, horizontalPositioning, verticalPositioning, spacedBy);
    }

    @Override
    @NonNull
    public String toString() {
        return this.getSerializedName() + " [" + this.mComponentId + ":" + this.mAnimationId + "] (" + this.mX + ", " + this.mY + " - " + this.mWidth + " x " + this.mHeight + ") " + this.mVisibility;
    }

    @Override
    @NonNull
    protected String getSerializedName() {
        return "ROW";
    }

    @Override
    public boolean isInHorizontalFill() {
        return super.isInHorizontalFill() || this.childrenHaveHorizontalWeights();
    }

    @Override
    public void computeWrapSize(@NonNull PaintContext context, float maxWidth, float maxHeight, boolean horizontalWrap, boolean verticalWrap, @NonNull MeasurePass measure, @NonNull Size size) {
        DebugLog.s(() -> "COMPUTE WRAP SIZE in " + this + " (" + this.mComponentId + ")");
        int visibleChildrens = 0;
        float currentMaxWidth = maxWidth;
        for (Component c : this.mChildrenComponents) {
            c.measure(context, 0.0f, currentMaxWidth, 0.0f, maxHeight, measure);
            ComponentMeasure m = measure.get(c);
            if (m.isGone()) continue;
            size.setWidth(size.getWidth() + m.getW());
            size.setHeight(Math.max(size.getHeight(), m.getH()));
            ++visibleChildrens;
            currentMaxWidth -= m.getW();
        }
        if (!this.mChildrenComponents.isEmpty()) {
            size.setWidth(size.getWidth() + this.mSpacedBy * (float)(visibleChildrens - 1));
        }
        DebugLog.e();
    }

    @Override
    public void computeSize(@NonNull PaintContext context, float minWidth, float maxWidth, float minHeight, float maxHeight, @NonNull MeasurePass measure) {
        DebugLog.s(() -> "COMPUTE SIZE in " + this + " (" + this.mComponentId + ")");
        float mw = maxWidth;
        for (Component child : this.mChildrenComponents) {
            child.measure(context, minWidth, mw, minHeight, maxHeight, measure);
            ComponentMeasure m = measure.get(child);
            if (m.isGone()) continue;
            mw -= m.getW();
        }
        DebugLog.e();
    }

    @Override
    public float minIntrinsicWidth(@Nullable RemoteContext context) {
        float width = this.computeModifierDefinedWidth(context);
        float componentWidths = 0.0f;
        for (Component c : this.mChildrenComponents) {
            componentWidths += c.minIntrinsicWidth(context);
        }
        return Math.max(width, componentWidths);
    }

    @Override
    public float minIntrinsicHeight(@Nullable RemoteContext context) {
        float height = this.computeModifierDefinedHeight(context);
        float componentHeights = 0.0f;
        for (Component c : this.mChildrenComponents) {
            componentHeights = Math.max(componentHeights, c.minIntrinsicHeight(context));
        }
        return Math.max(height, componentHeights);
    }

    @Override
    public void internalLayoutMeasure(@NonNull PaintContext context, @NonNull MeasurePass measure) {
        ComponentMeasure selfMeasure = measure.get(this);
        DebugLog.s(() -> "INTERNAL LAYOUT " + this + " (" + this.mComponentId + ") children: " + this.mChildrenComponents.size() + " size (" + selfMeasure.getW() + " x " + selfMeasure.getH() + ")");
        if (this.mChildrenComponents.isEmpty()) {
            DebugLog.e();
            return;
        }
        float selfWidth = selfMeasure.getW() - this.mPaddingLeft - this.mPaddingRight;
        float selfHeight = selfMeasure.getH() - this.mPaddingTop - this.mPaddingBottom;
        float childrenWidth = 0.0f;
        float childrenHeight = 0.0f;
        if (this.mComponentModifiers.hasHorizontalScroll()) {
            selfWidth = this.mComponentModifiers.getHorizontalScrollDimension() - this.mPaddingLeft - this.mPaddingRight;
        }
        if (this.mComponentModifiers.hasVerticalScroll()) {
            selfHeight = this.mComponentModifiers.getVerticalScrollDimension() - this.mPaddingTop - this.mPaddingBottom;
        }
        boolean checkWeights = true;
        while (checkWeights) {
            checkWeights = false;
            childrenWidth = 0.0f;
            childrenHeight = 0.0f;
            boolean hasWeights = false;
            float totalWeights = 0.0f;
            for (Object child : this.mChildrenComponents) {
                ComponentMeasure childMeasure = measure.get((Component)child);
                if (childMeasure.isGone()) continue;
                if (child instanceof LayoutComponent && ((LayoutComponent)child).getWidthModifier().hasWeight()) {
                    hasWeights = true;
                    totalWeights += ((LayoutComponent)child).getWidthModifier().getValue();
                    continue;
                }
                childrenWidth += childMeasure.getW();
            }
            if (hasWeights) {
                Object child;
                float availableSpace = selfWidth - childrenWidth;
                child = this.mChildrenComponents.iterator();
                while (child.hasNext()) {
                    ComponentMeasure childMeasure;
                    Component child2 = (Component)child.next();
                    if (!(child2 instanceof LayoutComponent) || !((LayoutComponent)child2).getWidthModifier().hasWeight() || (childMeasure = measure.get(child2)).isGone()) continue;
                    float weight = ((LayoutComponent)child2).getWidthModifier().getValue();
                    float childWidth = weight * availableSpace / totalWeights;
                    WidthInModifierOperation widthInConstraints = ((LayoutComponent)child2).getWidthModifier().getWidthIn();
                    if (widthInConstraints != null) {
                        float min = widthInConstraints.getMin();
                        float max = widthInConstraints.getMax();
                        if (min != -1.0f) {
                            childWidth = Math.max(min, childWidth);
                        }
                        if (max != -1.0f) {
                            childWidth = Math.min(max, childWidth);
                        }
                    }
                    childMeasure.setW(childWidth);
                    child2.measure(context, childMeasure.getW(), childMeasure.getW(), childMeasure.getH(), childMeasure.getH(), measure);
                }
            }
            if (!this.applyVisibility(selfWidth, selfHeight, measure) || !hasWeights) continue;
            checkWeights = true;
        }
        childrenWidth = 0.0f;
        int visibleChildrens = 0;
        for (Component child : this.mChildrenComponents) {
            ComponentMeasure childMeasure = measure.get(child);
            if (childMeasure.isGone()) continue;
            childrenWidth += childMeasure.getW();
            childrenHeight = Math.max(childrenHeight, childMeasure.getH());
            ++visibleChildrens;
        }
        childrenWidth += this.mSpacedBy * (float)(visibleChildrens - 1);
        float tx = 0.0f;
        float ty = 0.0f;
        float horizontalGap = 0.0f;
        float total = 0.0f;
        switch (this.mHorizontalPositioning) {
            case 1: {
                tx = 0.0f;
                break;
            }
            case 3: {
                tx = selfWidth - childrenWidth;
                break;
            }
            case 2: {
                tx = (selfWidth - childrenWidth) / 2.0f;
                break;
            }
            case 6: {
                for (Component child : this.mChildrenComponents) {
                    ComponentMeasure childMeasure = measure.get(child);
                    if (childMeasure.isGone()) continue;
                    total += childMeasure.getW();
                }
                if (visibleChildrens > 1) {
                    horizontalGap = (selfWidth - total) / (float)(visibleChildrens - 1);
                    break;
                }
                tx = (selfWidth - childrenWidth) / 2.0f;
                break;
            }
            case 7: {
                for (Component child : this.mChildrenComponents) {
                    ComponentMeasure childMeasure = measure.get(child);
                    if (childMeasure.isGone()) continue;
                    total += childMeasure.getW();
                }
                tx = horizontalGap = (selfWidth - total) / (float)(visibleChildrens + 1);
                break;
            }
            case 8: {
                for (Component child : this.mChildrenComponents) {
                    ComponentMeasure childMeasure = measure.get(child);
                    if (childMeasure.isGone()) continue;
                    total += childMeasure.getW();
                }
                horizontalGap = (selfWidth - total) / (float)visibleChildrens;
                tx = horizontalGap / 2.0f;
            }
        }
        for (Component child : this.mChildrenComponents) {
            ComponentMeasure childMeasure = measure.get(child);
            switch (this.mVerticalPositioning) {
                case 4: {
                    ty = 0.0f;
                    break;
                }
                case 2: {
                    ty = (selfHeight - childMeasure.getH()) / 2.0f;
                    break;
                }
                case 5: {
                    ty = selfHeight - childMeasure.getH();
                }
            }
            childMeasure.setX(tx);
            childMeasure.setY(ty);
            if (childMeasure.isGone()) continue;
            tx += childMeasure.getW();
            if (this.mHorizontalPositioning == 6 || this.mHorizontalPositioning == 8 || this.mHorizontalPositioning == 7) {
                tx += horizontalGap;
            }
            tx += this.mSpacedBy;
        }
        DebugLog.e();
    }

    @Override
    public void getLocationInWindow(@NonNull float[] value, boolean forSelf) {
        super.getLocationInWindow(value, forSelf);
        if (!forSelf && this.mHorizontalScrollDelegate instanceof ScrollModifierOperation) {
            ScrollModifierOperation smo = (ScrollModifierOperation)this.mHorizontalScrollDelegate;
            value[0] = value[0] + smo.getScrollX();
        }
    }

    @NonNull
    public static String name() {
        return "RowLayout";
    }

    public static int id() {
        return 203;
    }

    public static void apply(@NonNull WireBuffer buffer, int componentId, int animationId, int horizontalPositioning, int verticalPositioning, float spacedBy) {
        buffer.start(RowLayout.id());
        buffer.writeInt(componentId);
        buffer.writeInt(animationId);
        buffer.writeInt(horizontalPositioning);
        buffer.writeInt(verticalPositioning);
        buffer.writeFloat(spacedBy);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int componentId = buffer.readInt();
        int animationId = buffer.readInt();
        int horizontalPositioning = buffer.readInt();
        int verticalPositioning = buffer.readInt();
        float spacedBy = buffer.readFloat();
        operations.add(new RowLayout(null, componentId, animationId, horizontalPositioning, verticalPositioning, spacedBy));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", RowLayout.id(), RowLayout.name()).description("Row layout implementation, positioning components one after the other horizontally.\n\nIt supports weight and horizontal/vertical positioning.").examplesDimension(400, 100).exampleImage("Start", "layout-RowLayout-start-top.png").exampleImage("Center", "layout-RowLayout-center-top.png").exampleImage("End", "layout-RowLayout-end-top.png").exampleImage("SpaceEvenly", "layout-RowLayout-space-evenly-top.png").exampleImage("SpaceAround", "layout-RowLayout-space-around-top.png").exampleImage("SpaceBetween", "layout-RowLayout-space-between-top.png").field(0, "COMPONENT_ID", "unique id for this component").field(0, "ANIMATION_ID", "id used to match components, for animation purposes").field(0, "HORIZONTAL_POSITIONING", "horizontal positioning value").possibleValues("START", 1).possibleValues("CENTER", 2).possibleValues("END", 3).possibleValues("SPACE_BETWEEN", 6).possibleValues("SPACE_EVENLY", 7).possibleValues("SPACE_AROUND", 8).field(0, "VERTICAL_POSITIONING", "vertical positioning value").possibleValues("TOP", 4).possibleValues("CENTER", 2).possibleValues("BOTTOM", 5).field(1, "SPACED_BY", "Horizontal spacing between components");
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        RowLayout.apply(buffer, this.mComponentId, this.mAnimationId, this.mHorizontalPositioning, this.mVerticalPositioning, this.mSpacedBy);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        super.serialize(serializer);
        serializer.add("verticalPositioning", this.getPositioningString(this.mVerticalPositioning));
        serializer.add("horizontalPositioning", this.getPositioningString(this.mHorizontalPositioning));
        serializer.add("spacedBy", Float.valueOf(this.mSpacedBy));
    }

    private String getPositioningString(int pos) {
        switch (pos) {
            case 1: {
                return "START";
            }
            case 2: {
                return "CENTER";
            }
            case 3: {
                return "END";
            }
            case 4: {
                return "TOP";
            }
            case 5: {
                return "BOTTOM";
            }
            case 6: {
                return "SPACE_BETWEEN";
            }
            case 7: {
                return "SPACE_EVENLY";
            }
            case 8: {
                return "SPACE_AROUND";
            }
        }
        return "NONE";
    }
}

