/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.managers;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.ComponentMeasure;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.Measurable;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.MeasurePass;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.Size;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.HeightInModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.WidthInModifierOperation;

public abstract class LayoutManager
extends LayoutComponent
implements Measurable {
    @NonNull
    Size mCachedWrapSize = new Size(0.0f, 0.0f);

    public LayoutManager(@Nullable Component parent, int componentId, int animationId, float x, float y, float width, float height) {
        super(parent, componentId, animationId, x, y, width, height);
    }

    public boolean applyVisibility(float selfWidth, float selfHeight, @NonNull MeasurePass measure) {
        return false;
    }

    public void internalLayoutMeasure(@NonNull PaintContext context, @NonNull MeasurePass measure) {
    }

    public void computeWrapSize(@NonNull PaintContext context, float maxWidth, float maxHeight, boolean horizontalWrap, boolean verticalWrap, @NonNull MeasurePass measure, @NonNull Size size) {
    }

    @Override
    public float minIntrinsicHeight(@Nullable RemoteContext context) {
        float height = this.computeModifierDefinedHeight(context);
        for (Component c : this.mChildrenComponents) {
            height = Math.max(c.minIntrinsicHeight(context), height);
        }
        return height;
    }

    @Override
    public float minIntrinsicWidth(@Nullable RemoteContext context) {
        float width = this.computeModifierDefinedWidth(context);
        for (Component c : this.mChildrenComponents) {
            width = Math.max(c.minIntrinsicWidth(context), width);
        }
        return width;
    }

    public void computeSize(@NonNull PaintContext context, float minWidth, float maxWidth, float minHeight, float maxHeight, @NonNull MeasurePass measure) {
    }

    protected boolean childrenHaveHorizontalWeights() {
        for (Component c : this.mChildrenComponents) {
            LayoutManager m;
            if (!(c instanceof LayoutManager) || (m = (LayoutManager)c).getWidthModifier() == null || !m.getWidthModifier().hasWeight()) continue;
            return true;
        }
        return false;
    }

    protected boolean childrenHaveVerticalWeights() {
        for (Component c : this.mChildrenComponents) {
            LayoutManager m;
            if (!(c instanceof LayoutManager) || (m = (LayoutManager)c).getHeightModifier() == null || !m.getHeightModifier().hasWeight()) continue;
            return true;
        }
        return false;
    }

    public boolean isInHorizontalFill() {
        return this.mWidthModifier.isFill();
    }

    public boolean isInVerticalFill() {
        return this.mHeightModifier.isFill();
    }

    private void measure_v0_4_0(@NonNull PaintContext context, float minWidth, float maxWidth, float minHeight, float maxHeight, @NonNull MeasurePass measure) {
        boolean hasWrap = true;
        float measuredWidth = Math.min(maxWidth, this.computeModifierDefinedWidth(context.getContext()));
        float measuredHeight = Math.min(maxHeight, this.computeModifierDefinedHeight(context.getContext()));
        if (this.mWidthModifier.isIntrinsicMin()) {
            maxWidth = this.minIntrinsicWidth(context.getContext()) + this.mPaddingLeft + this.mPaddingRight;
        }
        if (this.mHeightModifier.isIntrinsicMin()) {
            maxHeight = this.minIntrinsicHeight(context.getContext()) + this.mPaddingTop + this.mPaddingBottom;
        }
        float insetMaxWidth = maxWidth - this.mPaddingLeft - this.mPaddingRight;
        float insetMaxHeight = maxHeight - this.mPaddingTop - this.mPaddingBottom;
        boolean hasHorizontalWrap = this.mWidthModifier.isWrap();
        boolean hasVerticalWrap = this.mHeightModifier.isWrap();
        if (hasHorizontalWrap || hasVerticalWrap) {
            this.mCachedWrapSize.setWidth(0.0f);
            this.mCachedWrapSize.setHeight(0.0f);
            this.computeWrapSize(context, insetMaxWidth, insetMaxHeight, this.mWidthModifier.isWrap(), this.mHeightModifier.isWrap(), measure, this.mCachedWrapSize);
            int selfVisibilityAfterMeasure = measure.get(this).getVisibility();
            if (Component.Visibility.hasOverride(selfVisibilityAfterMeasure) && this.mScheduledVisibility != selfVisibilityAfterMeasure) {
                this.mScheduledVisibility = selfVisibilityAfterMeasure;
            }
            measuredWidth = this.mCachedWrapSize.getWidth();
            if (hasHorizontalWrap) {
                measuredWidth += this.mPaddingLeft + this.mPaddingRight;
            }
            measuredHeight = this.mCachedWrapSize.getHeight();
            if (hasVerticalWrap) {
                measuredHeight += this.mPaddingTop + this.mPaddingBottom;
            }
        } else {
            hasWrap = false;
        }
        if (this.isInHorizontalFill()) {
            measuredWidth = maxWidth;
        } else if (this.mWidthModifier.hasWeight()) {
            measuredWidth = Math.max(measuredWidth, this.computeModifierDefinedWidth(context.getContext()));
        } else {
            measuredWidth = Math.max(measuredWidth, minWidth);
            measuredWidth = Math.min(measuredWidth, maxWidth);
        }
        if (this.isInVerticalFill()) {
            measuredHeight = maxHeight;
        } else if (this.mHeightModifier.hasWeight()) {
            measuredHeight = Math.max(measuredHeight, this.computeModifierDefinedHeight(context.getContext()));
        } else {
            measuredHeight = Math.max(measuredHeight, minHeight);
            measuredHeight = Math.min(measuredHeight, maxHeight);
        }
        if (minWidth == maxWidth) {
            measuredWidth = maxWidth;
        }
        if (minHeight == maxHeight) {
            measuredHeight = maxHeight;
        }
        if (!hasWrap) {
            if (this.hasHorizontalIntrinsicDimension()) {
                this.mCachedWrapSize.setWidth(0.0f);
                this.mCachedWrapSize.setHeight(0.0f);
                this.computeWrapSize(context, Float.MAX_VALUE, maxHeight, false, false, measure, this.mCachedWrapSize);
                float w = this.mCachedWrapSize.getWidth();
                if (this.hasHorizontalScroll()) {
                    this.computeSize(context, 0.0f, w, 0.0f, measuredHeight, measure);
                    this.mComponentModifiers.setHorizontalScrollDimension(measuredWidth, w);
                } else {
                    this.computeSize(context, 0.0f, Math.min(measuredWidth, insetMaxWidth), 0.0f, Math.min(measuredHeight, insetMaxHeight), measure);
                }
            } else if (this.hasVerticalIntrinsicDimension()) {
                this.mCachedWrapSize.setWidth(0.0f);
                this.mCachedWrapSize.setHeight(0.0f);
                this.computeWrapSize(context, maxWidth, Float.MAX_VALUE, false, false, measure, this.mCachedWrapSize);
                float h = this.mCachedWrapSize.getHeight();
                if (this.hasVerticalScroll()) {
                    this.computeSize(context, 0.0f, measuredWidth, 0.0f, h, measure);
                    this.mComponentModifiers.setVerticalScrollDimension(measuredHeight, h);
                } else {
                    this.computeSize(context, 0.0f, Math.min(measuredWidth, insetMaxWidth), 0.0f, Math.min(measuredHeight, insetMaxHeight), measure);
                }
            } else {
                float maxChildWidth = measuredWidth - this.mPaddingLeft - this.mPaddingRight;
                float maxChildHeight = measuredHeight - this.mPaddingTop - this.mPaddingBottom;
                this.computeSize(context, 0.0f, maxChildWidth, 0.0f, maxChildHeight, measure);
            }
        }
        if (this.mContent != null) {
            ComponentMeasure cm = measure.get(this.mContent);
            cm.setX(0.0f);
            cm.setY(0.0f);
            cm.setW(measuredWidth);
            cm.setH(measuredHeight);
        }
        ComponentMeasure m = measure.get(this);
        m.setW(measuredWidth);
        m.setH(measuredHeight);
        m.setVisibility(this.mScheduledVisibility);
        this.internalLayoutMeasure(context, measure);
    }

    private void measure_v0_4_1(@NonNull PaintContext context, float minWidth, float maxWidth, float minHeight, float maxHeight, @NonNull MeasurePass measure) {
        HeightInModifierOperation heightIn;
        WidthInModifierOperation widthIn;
        float measuredWidth = Math.min(maxWidth, this.computeModifierDefinedWidth(context.getContext()));
        float measuredHeight = Math.min(maxHeight, this.computeModifierDefinedHeight(context.getContext()));
        if (this.mWidthModifier.isIntrinsicMin()) {
            maxWidth = this.minIntrinsicWidth(context.getContext()) + this.mPaddingLeft + this.mPaddingRight;
        }
        if (this.mHeightModifier.isIntrinsicMin()) {
            maxHeight = this.minIntrinsicHeight(context.getContext()) + this.mPaddingTop + this.mPaddingBottom;
        }
        if ((widthIn = this.mWidthModifier.getWidthIn()) != null) {
            minWidth = Math.max(minWidth, widthIn.getMin());
            maxWidth = Math.min(maxWidth, widthIn.getMax());
        }
        if ((heightIn = this.mHeightModifier.getHeightIn()) != null) {
            minHeight = Math.max(minHeight, heightIn.getMin());
            maxHeight = Math.min(maxHeight, heightIn.getMax());
        }
        float insetMaxWidth = maxWidth - this.mPaddingLeft - this.mPaddingRight;
        float insetMaxHeight = maxHeight - this.mPaddingTop - this.mPaddingBottom;
        boolean hasHorizontalWrap = false;
        boolean hasVerticalWrap = false;
        if (this.isInHorizontalFill()) {
            measuredWidth = maxWidth;
        } else if (this.mWidthModifier.hasWeight()) {
            measuredWidth = Math.max(measuredWidth, this.computeModifierDefinedWidth(context.getContext()));
        } else {
            measuredWidth = Math.max(measuredWidth, minWidth);
            measuredWidth = Math.min(measuredWidth, maxWidth);
            boolean bl = hasHorizontalWrap = this.mWidthModifier.isWrap() || this.mWidthModifier.isIntrinsicMin();
        }
        if (this.isInVerticalFill()) {
            measuredHeight = maxHeight;
        } else if (this.mHeightModifier.hasWeight()) {
            measuredHeight = Math.max(measuredHeight, this.computeModifierDefinedHeight(context.getContext()));
        } else {
            measuredHeight = Math.max(measuredHeight, minHeight);
            measuredHeight = Math.min(measuredHeight, maxHeight);
            boolean bl = hasVerticalWrap = this.mHeightModifier.isWrap() || this.mHeightModifier.isIntrinsicMin();
        }
        if (minWidth == maxWidth) {
            measuredWidth = maxWidth;
        }
        if (minHeight == maxHeight) {
            measuredHeight = maxHeight;
        }
        if (hasHorizontalWrap || hasVerticalWrap) {
            this.mCachedWrapSize.setWidth(0.0f);
            this.mCachedWrapSize.setHeight(0.0f);
            this.computeWrapSize(context, insetMaxWidth, insetMaxHeight, this.mWidthModifier.isWrap(), this.mHeightModifier.isWrap(), measure, this.mCachedWrapSize);
            int selfVisibilityAfterMeasure = measure.get(this).getVisibility();
            if (Component.Visibility.hasOverride(selfVisibilityAfterMeasure) && this.mScheduledVisibility != selfVisibilityAfterMeasure) {
                this.mScheduledVisibility = selfVisibilityAfterMeasure;
            }
            if (hasHorizontalWrap) {
                measuredWidth = this.mCachedWrapSize.getWidth();
                measuredWidth += this.mPaddingLeft + this.mPaddingRight;
                measuredWidth = Math.max(measuredWidth, minWidth);
            }
            if (hasVerticalWrap) {
                measuredHeight = this.mCachedWrapSize.getHeight();
                measuredHeight += this.mPaddingTop + this.mPaddingBottom;
                measuredHeight = Math.max(measuredHeight, minHeight);
            }
        } else if (this.hasHorizontalIntrinsicDimension()) {
            this.mCachedWrapSize.setWidth(0.0f);
            this.mCachedWrapSize.setHeight(0.0f);
            this.computeWrapSize(context, Float.MAX_VALUE, maxHeight, false, false, measure, this.mCachedWrapSize);
            float w = this.mCachedWrapSize.getWidth();
            if (this.hasHorizontalScroll()) {
                this.computeSize(context, 0.0f, w, 0.0f, measuredHeight, measure);
                this.mComponentModifiers.setHorizontalScrollDimension(measuredWidth, w);
            } else {
                this.computeSize(context, 0.0f, Math.min(measuredWidth, insetMaxWidth), 0.0f, Math.min(measuredHeight, insetMaxHeight), measure);
            }
        } else if (this.hasVerticalIntrinsicDimension()) {
            this.mCachedWrapSize.setWidth(0.0f);
            this.mCachedWrapSize.setHeight(0.0f);
            this.computeWrapSize(context, maxWidth, Float.MAX_VALUE, false, false, measure, this.mCachedWrapSize);
            float h = this.mCachedWrapSize.getHeight();
            if (this.hasVerticalScroll()) {
                this.computeSize(context, 0.0f, measuredWidth, 0.0f, h, measure);
                this.mComponentModifiers.setVerticalScrollDimension(measuredHeight, h);
            } else {
                this.computeSize(context, 0.0f, Math.min(measuredWidth, insetMaxWidth), 0.0f, Math.min(measuredHeight, insetMaxHeight), measure);
            }
        } else {
            float maxChildWidth = measuredWidth - this.mPaddingLeft - this.mPaddingRight;
            float maxChildHeight = measuredHeight - this.mPaddingTop - this.mPaddingBottom;
            this.computeSize(context, 0.0f, maxChildWidth, 0.0f, maxChildHeight, measure);
        }
        if (this.mContent != null) {
            ComponentMeasure cm = measure.get(this.mContent);
            cm.setX(0.0f);
            cm.setY(0.0f);
            cm.setW(measuredWidth);
            cm.setH(measuredHeight);
        }
        measuredWidth = Math.max(measuredWidth, minWidth);
        measuredHeight = Math.max(measuredHeight, minHeight);
        ComponentMeasure m = measure.get(this);
        m.setW(measuredWidth);
        m.setH(measuredHeight);
        m.setVisibility(this.mScheduledVisibility);
        this.internalLayoutMeasure(context, measure);
    }

    @Override
    public void measure(@NonNull PaintContext context, float minWidth, float maxWidth, float minHeight, float maxHeight, @NonNull MeasurePass measure) {
        if (context.supportsVersion(0, 4, 1)) {
            this.measure_v0_4_1(context, minWidth, maxWidth, minHeight, maxHeight, measure);
        } else {
            this.measure_v0_4_0(context, minWidth, maxWidth, minHeight, maxHeight, measure);
        }
    }

    private boolean hasHorizontalScroll() {
        return this.mComponentModifiers.hasHorizontalScroll();
    }

    protected boolean hasHorizontalIntrinsicDimension() {
        return this.hasHorizontalScroll();
    }

    protected boolean hasVerticalIntrinsicDimension() {
        return this.hasVerticalScroll();
    }

    private boolean hasVerticalScroll() {
        return this.mComponentModifiers.hasVerticalScroll();
    }

    @Override
    public void layout(@NonNull RemoteContext context, @NonNull MeasurePass measure) {
        super.layout(context, measure);
        ComponentMeasure self = measure.get(this);
        this.mComponentModifiers.layout(context, this, self.getW(), self.getH());
        for (Component c : this.mChildrenComponents) {
            c.layout(context, measure);
        }
        this.mNeedsMeasure = false;
    }

    public void selfLayout(@NonNull RemoteContext context, @NonNull MeasurePass measure) {
        super.layout(context, measure);
        ComponentMeasure self = measure.get(this);
        this.mComponentModifiers.layout(context, this, self.getW(), self.getH());
        this.mNeedsMeasure = false;
    }
}

