/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.managers;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.BoxLayout;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.ComponentMeasure;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.MeasurePass;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class CanvasLayout
extends BoxLayout {
    public CanvasLayout(@Nullable Component parent, int componentId, int animationId, float x, float y, float width, float height) {
        super(parent, componentId, animationId, x, y, width, height, 0, 0);
    }

    public CanvasLayout(@Nullable Component parent, int componentId, int animationId) {
        this(parent, componentId, animationId, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NonNull
    public String toString() {
        return "CANVAS [" + this.mComponentId + ":" + this.mAnimationId + "] (" + this.mX + ", " + this.mY + " - " + this.mWidth + " x " + this.mHeight + ") " + this.mVisibility;
    }

    @Override
    @NonNull
    protected String getSerializedName() {
        return "CANVAS";
    }

    @NonNull
    public static String name() {
        return "CanvasLayout";
    }

    public static int id() {
        return 205;
    }

    public static void apply(@NonNull WireBuffer buffer, int componentId, int animationId) {
        buffer.start(205);
        buffer.writeInt(componentId);
        buffer.writeInt(animationId);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int componentId = buffer.readInt();
        int animationId = buffer.readInt();
        operations.add(new CanvasLayout(null, componentId, animationId));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", CanvasLayout.id(), CanvasLayout.name()).description("Canvas implementation. Encapsulate draw operations.\n\n").field(0, "COMPONENT_ID", "unique id for this component").field(0, "ANIMATION_ID", "id used to match components, for animation purposes");
    }

    @Override
    public void internalLayoutMeasure(@NonNull PaintContext context, @NonNull MeasurePass measure) {
        ComponentMeasure selfMeasure = measure.get(this);
        float selfWidth = selfMeasure.getW() - this.mPaddingLeft - this.mPaddingRight;
        float selfHeight = selfMeasure.getH() - this.mPaddingTop - this.mPaddingBottom;
        for (Component child : this.mChildrenComponents) {
            ComponentMeasure m = measure.get(child);
            m.setX(0.0f);
            m.setY(0.0f);
            m.setW(selfWidth);
            m.setH(selfHeight);
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        CanvasLayout.apply(buffer, this.mComponentId, this.mAnimationId);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        super.serialize(serializer);
        serializer.addType(this.getSerializedName());
    }
}

