/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import java.util.List;

public class CanvasContent
extends Component {
    public CanvasContent(int componentId, float x, float y, float width, float height, @Nullable Component parent, int animationId) {
        super(parent, componentId, animationId, x, y, width, height);
    }

    @NonNull
    public static String name() {
        return "CanvasContent";
    }

    public static int id() {
        return 207;
    }

    @Override
    @NonNull
    protected String getSerializedName() {
        return "CANVAS_CONTENT";
    }

    public static void apply(@NonNull WireBuffer buffer, int componentId) {
        buffer.start(207);
        buffer.writeInt(componentId);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int componentId = buffer.readInt();
        operations.add(new CanvasContent(componentId, 0.0f, 0.0f, 0.0f, 0.0f, null, -1));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", CanvasContent.id(), CanvasContent.name()).field(0, "COMPONENT_ID", "unique id for this component").description("Container for canvas commands.");
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        CanvasContent.apply(buffer, this.mComponentId);
    }
}

