/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout;

import com.android.internal.lang.System_Delegate;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.utilities.easing.FloatAnimation;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;

public class AnimatableValue
implements Serializable {
    boolean mIsVariable = false;
    int mId = 0;
    float mValue = 0.0f;
    boolean mAnimateValueChanges = true;
    boolean mAnimate = false;
    long mAnimateTargetTime = 0L;
    float mAnimateDuration = 300.0f;
    float mTargetRotationX;
    float mStartRotationX;
    long mLastUpdate = 0L;
    int mMotionEasingType = 1;
    FloatAnimation mMotionEasing;

    public AnimatableValue(float value, boolean animateValueChanges) {
        this.mAnimateValueChanges = animateValueChanges;
        if (Utils.isVariable(value)) {
            this.mId = Utils.idFromNan(value);
            this.mIsVariable = true;
        } else {
            this.mValue = value;
        }
    }

    public AnimatableValue(float value) {
        this(value, true);
    }

    public float getValue() {
        return this.mValue;
    }

    public float evaluate(PaintContext context) {
        if (!this.mIsVariable) {
            return this.mValue;
        }
        float value = context.getContext().mRemoteComposeState.getFloat(this.mId);
        if (value != this.mValue) {
            long lastUpdate = System_Delegate.currentTimeMillis();
            long interval = lastUpdate - this.mLastUpdate;
            this.mAnimateValueChanges = (float)interval > this.mAnimateDuration && this.mLastUpdate != 0L;
            this.mLastUpdate = lastUpdate;
        }
        if (!this.mAnimateValueChanges) {
            this.mValue = value;
        } else {
            if (value != this.mValue && !this.mAnimate) {
                this.mStartRotationX = this.mValue;
                this.mTargetRotationX = value;
                this.mAnimate = true;
                this.mAnimateTargetTime = System_Delegate.currentTimeMillis();
                this.mMotionEasing = new FloatAnimation(this.mMotionEasingType, this.mAnimateDuration / 1000.0f, null, 0.0f, Float.NaN);
                this.mMotionEasing.setTargetValue(1.0f);
            }
            if (this.mAnimate) {
                float elapsed = System_Delegate.currentTimeMillis() - this.mAnimateTargetTime;
                float p = this.mMotionEasing.get(elapsed / this.mAnimateDuration);
                this.mValue = (1.0f - p) * this.mStartRotationX + p * this.mTargetRotationX;
                if (p >= 1.0f) {
                    this.mAnimate = false;
                }
            } else {
                this.mValue = this.mTargetRotationX;
            }
        }
        return this.mValue;
    }

    public String toString() {
        return "AnimatableValue{mId=" + this.mId + "}";
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType("AnimatableValue").add("id", this.mId);
    }
}

