/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.lang.System_Delegate;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.types.LongConstant;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TimeAttribute
extends PaintOperation {
    private static final int OP_CODE = 172;
    private static final String CLASS_NAME = "TimeAttribute";
    private final int[] mArgs;
    public int mId;
    public int mTimeId;
    public short mType;
    public static final short TIME_FROM_NOW_SEC = 0;
    public static final short TIME_FROM_NOW_MIN = 1;
    public static final short TIME_FROM_NOW_HR = 2;
    public static final short TIME_FROM_ARG_SEC = 3;
    public static final short TIME_FROM_ARG_MIN = 4;
    public static final short TIME_FROM_ARG_HR = 5;
    public static final short TIME_IN_SEC = 6;
    public static final short TIME_IN_MIN = 7;
    public static final short TIME_IN_HR = 8;
    public static final short TIME_DAY_OF_MONTH = 9;
    public static final short TIME_MONTH_VALUE = 10;
    public static final short TIME_DAY_OF_WEEK = 11;
    public static final short TIME_YEAR = 12;
    public static final short TIME_FROM_LOAD_SEC = 14;
    @NonNull
    float[] mBounds = new float[4];

    public TimeAttribute(int id2, int longId, short type, int[] args) {
        this.mId = id2;
        this.mTimeId = longId;
        this.mType = type;
        this.mArgs = args;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        TimeAttribute.apply(buffer, this.mId, this.mTimeId, this.mType);
    }

    @NonNull
    public String toString() {
        if (this.mArgs == null) {
            return "TimeAttribute[" + this.mId + "] = " + this.mTimeId + " " + this.mType;
        }
        return "TimeAttribute[" + this.mId + "] = " + this.mTimeId + " " + this.mType + " " + Arrays.toString(this.mArgs);
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 172;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, int textId, short type) {
        TimeAttribute.apply(buffer, id2, textId, type, null);
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, int textId, short type, int[] args) {
        buffer.start(172);
        buffer.writeInt(id2);
        buffer.writeInt(textId);
        buffer.writeShort(type);
        if (args == null) {
            buffer.writeShort(0);
        } else {
            buffer.writeShort(args.length);
            for (int arg : args) {
                buffer.writeInt(arg);
            }
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int textId = buffer.readInt();
        short type = (short)buffer.readShort();
        int len = buffer.readShort();
        int[] args = null;
        if (len != 0) {
            args = new int[len];
            for (int i = 0; i < len; ++i) {
                args[i] = buffer.readInt();
            }
        }
        operations.add(new TimeAttribute(id2, textId, type, args));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Time Operations", 172, CLASS_NAME).description("Calculate Information about time").field(0, "id", "id to output").field(0, "longId", "id of time to calculate on").field(9, "type", "the type of calculation").field(9, "argsLength", "The number of additional args").field(0, "args", "argsLength", "The number of additional args");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        int val = this.mType & 0xFF;
        int flags = this.mType >> 8;
        RemoteContext ctx = context.getContext();
        long load_time = ctx.getDocLoadTime();
        LongConstant longConstant = (LongConstant)ctx.getObject(this.mTimeId);
        long value = longConstant.getValue();
        long delta = 0L;
        LocalDateTime time = null;
        switch (val) {
            case 0: 
            case 1: 
            case 2: {
                delta = value - System_Delegate.currentTimeMillis();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                LongConstant lc2 = (LongConstant)ctx.getObject(this.mArgs[0]);
                delta = value - lc2.getValue();
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                time = Instant.ofEpochMilli(value).atZone(ZoneOffset.systemDefault()).toLocalDateTime();
            }
        }
        switch (val) {
            case 0: 
            case 3: {
                ctx.loadFloat(this.mId, (float)delta * 0.001f);
                ctx.needsRepaint();
                break;
            }
            case 1: 
            case 4: {
                ctx.loadFloat(this.mId, (float)((double)delta * 0.001 / 60.0));
                ctx.needsRepaint();
                break;
            }
            case 2: 
            case 5: {
                ctx.loadFloat(this.mId, (float)((double)delta * 0.001 / 3600.0));
                break;
            }
            case 6: {
                ctx.loadFloat(this.mId, time.getSecond());
                break;
            }
            case 7: {
                ctx.loadFloat(this.mId, time.getMinute());
                break;
            }
            case 8: {
                ctx.loadFloat(this.mId, time.getHour());
                break;
            }
            case 9: {
                ctx.loadFloat(this.mId, time.getDayOfMonth());
                break;
            }
            case 10: {
                ctx.loadFloat(this.mId, time.getMonthValue() - 1);
                break;
            }
            case 11: {
                ctx.loadFloat(this.mId, time.getDayOfWeek().ordinal());
                break;
            }
            case 12: {
                ctx.loadFloat(this.mId, time.getYear());
                break;
            }
            case 14: {
                ctx.loadFloat(this.mId, (float)(value - load_time) * 0.001f);
                ctx.needsRepaint();
            }
        }
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("timeId", this.mTimeId).addType(this.getTypeString()).add("args", Collections.singletonList(this.mArgs));
    }

    private String getTypeString() {
        int val = this.mType & 0xFF;
        switch (val) {
            case 0: {
                return "TIME_FROM_NOW_SEC";
            }
            case 1: {
                return "TIME_FROM_NOW_MIN";
            }
            case 2: {
                return "TIME_FROM_NOW_HR";
            }
            case 3: {
                return "TIME_FROM_ARG_SEC";
            }
            case 4: {
                return "TIME_FROM_ARG_MIN";
            }
            case 5: {
                return "TIME_FROM_ARG_HR";
            }
            case 6: {
                return "TIME_IN_SEC";
            }
            case 7: {
                return "TIME_IN_MIN";
            }
            case 8: {
                return "TIME_IN_HR";
            }
            case 9: {
                return "TIME_DAY_OF_MONTH";
            }
            case 10: {
                return "TIME_MONTH_VALUE";
            }
            case 11: {
                return "TIME_DAY_OF_WEEK";
            }
            case 12: {
                return "TIME_YEAR";
            }
            case 14: {
                return "TIME_FROM_LOAD_SEC";
            }
        }
        return "INVALID_TIME_TYPE";
    }
}

