/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class TextLookup
extends Operation
implements VariableSupport,
Serializable {
    private static final int OP_CODE = 151;
    private static final String CLASS_NAME = "TextFromFloat";
    public int mTextId;
    public int mDataSetId;
    public float mOutIndex;
    public float mIndex;
    public static final int MAX_STRING_SIZE = 4000;

    public TextLookup(int textId, int dataSetId, float index) {
        this.mTextId = textId;
        this.mDataSetId = dataSetId;
        this.mOutIndex = this.mIndex = index;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        TextLookup.apply(buffer, this.mTextId, this.mDataSetId, this.mIndex);
    }

    @NonNull
    public String toString() {
        return "TextLookup[" + Utils.idString(this.mTextId) + "] = " + Utils.idString(this.mDataSetId) + " " + Utils.floatToString(this.mIndex);
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        if (Float.isNaN(this.mIndex)) {
            this.mOutIndex = context.getFloat(Utils.idFromNan(this.mIndex));
        }
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (Float.isNaN(this.mIndex)) {
            context.listensTo(Utils.idFromNan(this.mIndex), this);
        }
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 151;
    }

    public static void apply(@NonNull WireBuffer buffer, int textId, int dataSet, float index) {
        buffer.start(151);
        buffer.writeInt(textId);
        buffer.writeInt(dataSet);
        buffer.writeFloat(index);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int textId = buffer.readInt();
        int dataSetId = buffer.readInt();
        float index = buffer.readFloat();
        operations.add(new TextLookup(textId, dataSetId, index));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 151, CLASS_NAME).description("Look an array and turn into a text object").field(0, "textId", "id of the text generated").field(1, "dataSet", "float pointer to the array/list to turn int a string").field(1, "index", "index of element to return");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        int id2 = context.getCollectionsAccess().getId(this.mDataSetId, (int)this.mOutIndex);
        context.loadText(this.mTextId, context.getText(id2));
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("textId", this.mTextId).add("dataSetId", this.mDataSetId).add("indexId", this.mIndex, this.mOutIndex);
    }
}

