/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class TextAttribute
extends PaintOperation
implements Serializable {
    private static final int OP_CODE = 170;
    private static final String CLASS_NAME = "TextMeasure";
    public int mId;
    public int mTextId;
    public short mType;
    public static final short MEASURE_WIDTH = 0;
    public static final short MEASURE_HEIGHT = 1;
    public static final short MEASURE_LEFT = 2;
    public static final short MEASURE_RIGHT = 3;
    public static final short MEASURE_TOP = 4;
    public static final short MEASURE_BOTTOM = 5;
    public static final short TEXT_LENGTH = 6;
    public static final int MEASURE_MONOSPACE_FLAG = 256;
    public static final int MEASURE_MAX_HEIGHT_FLAG = 512;
    @NonNull
    float[] mBounds = new float[4];

    public TextAttribute(int id2, int textId, short type) {
        this.mId = id2;
        this.mTextId = textId;
        this.mType = type;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        TextAttribute.apply(buffer, this.mId, this.mTextId, this.mType);
    }

    @NonNull
    public String toString() {
        return "FloatConstant[" + this.mId + "] = " + this.mTextId + " " + this.mType;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 170;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, int textId, short type) {
        buffer.start(170);
        buffer.writeInt(id2);
        buffer.writeInt(textId);
        buffer.writeShort(type);
        buffer.writeShort(0);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int textId = buffer.readInt();
        short type = (short)buffer.readShort();
        short len = (short)buffer.readShort();
        operations.add(new TextAttribute(id2, textId, type));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 170, CLASS_NAME).description("Measure text").field(0, "id", "id of float result of the measure").field(0, "textId", "id of text").field(0, "type", "type: measure 0=width,1=height");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        int val = this.mType & 0xFF;
        int flags = this.mType >> 8;
        if (val <= 5) {
            context.getTextBounds(this.mTextId, 0, -1, flags, this.mBounds);
        }
        switch (val) {
            case 0: {
                context.getContext().loadFloat(this.mId, this.mBounds[2] - this.mBounds[0]);
                break;
            }
            case 1: {
                context.getContext().loadFloat(this.mId, this.mBounds[3] - this.mBounds[1]);
                break;
            }
            case 2: {
                context.getContext().loadFloat(this.mId, this.mBounds[0]);
                break;
            }
            case 4: {
                context.getContext().loadFloat(this.mId, this.mBounds[1]);
                break;
            }
            case 3: {
                context.getContext().loadFloat(this.mId, this.mBounds[2]);
                break;
            }
            case 5: {
                context.getContext().loadFloat(this.mId, this.mBounds[3]);
                break;
            }
            case 6: {
                context.getContext().loadFloat(this.mId, context.getText(this.mTextId).length());
            }
        }
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("textId", this.mTextId).add("measureType", this.typeToString());
    }

    private String typeToString() {
        switch (this.mType) {
            case 0: {
                return "MEASURE_WIDTH";
            }
            case 1: {
                return "MEASURE_HEIGHT";
            }
            case 2: {
                return "MEASURE_LEFT";
            }
            case 3: {
                return "MEASURE_RIGHT";
            }
            case 4: {
                return "MEASURE_TOP";
            }
            case 5: {
                return "MEASURE_BOTTOM";
            }
            case 6: {
                return "TEXT_LENGTH";
            }
        }
        return "INVALID_TYPE";
    }
}

