/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ShaderData
extends Operation
implements VariableSupport,
Serializable {
    private static final int OP_CODE = 45;
    private static final String CLASS_NAME = "ShaderData";
    int mShaderTextId;
    int mShaderID;
    @Nullable
    HashMap<String, float[]> mUniformRawFloatMap = null;
    @Nullable
    HashMap<String, float[]> mUniformFloatMap = null;
    @Nullable
    HashMap<String, int[]> mUniformIntMap;
    @Nullable
    HashMap<String, Integer> mUniformBitmapMap = null;
    private boolean mShaderValid = false;

    public ShaderData(int shaderID, int shaderTextId, @Nullable HashMap<String, float[]> floatMap, @Nullable HashMap<String, int[]> intMap, @Nullable HashMap<String, Integer> bitmapMap) {
        this.mShaderID = shaderID;
        this.mShaderTextId = shaderTextId;
        if (floatMap != null) {
            this.mUniformFloatMap = new HashMap();
            this.mUniformRawFloatMap = new HashMap();
            for (String name : floatMap.keySet()) {
                this.mUniformRawFloatMap.put(name, floatMap.get(name));
                this.mUniformFloatMap.put(name, floatMap.get(name));
            }
        }
        if (intMap != null) {
            this.mUniformIntMap = new HashMap();
            for (String name : intMap.keySet()) {
                this.mUniformIntMap.put(name, intMap.get(name));
            }
        }
        if (bitmapMap != null) {
            this.mUniformBitmapMap = new HashMap();
            for (String name : bitmapMap.keySet()) {
                this.mUniformBitmapMap.put(name, bitmapMap.get(name));
            }
        }
    }

    public int getShaderTextId() {
        return this.mShaderTextId;
    }

    @NonNull
    public String[] getUniformFloatNames() {
        if (this.mUniformFloatMap == null) {
            return new String[0];
        }
        return this.mUniformFloatMap.keySet().toArray(new String[0]);
    }

    @NonNull
    public float[] getUniformFloats(@NonNull String name) {
        return this.mUniformFloatMap != null ? this.mUniformFloatMap.get(name) : new float[]{};
    }

    @NonNull
    public String[] getUniformIntegerNames() {
        if (this.mUniformIntMap == null) {
            return new String[0];
        }
        return this.mUniformIntMap.keySet().toArray(new String[0]);
    }

    @NonNull
    public int[] getUniformInts(@NonNull String name) {
        return this.mUniformIntMap != null ? this.mUniformIntMap.get(name) : new int[]{};
    }

    @NonNull
    public String[] getUniformBitmapNames() {
        if (this.mUniformBitmapMap == null) {
            return new String[0];
        }
        return this.mUniformBitmapMap.keySet().toArray(new String[0]);
    }

    public int getUniformBitmapId(@NonNull String name) {
        return this.mUniformBitmapMap != null ? this.mUniformBitmapMap.get(name) : -1;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ShaderData.apply(buffer, this.mShaderID, this.mShaderTextId, this.mUniformFloatMap, this.mUniformIntMap, this.mUniformBitmapMap);
    }

    @NonNull
    public String toString() {
        return "SHADER DATA " + this.mShaderID;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        if (this.mUniformRawFloatMap == null) {
            return;
        }
        for (String name : this.mUniformRawFloatMap.keySet()) {
            float[] value = this.mUniformRawFloatMap.get(name);
            float[] out = null;
            for (int i = 0; i < value.length; ++i) {
                if (!Float.isNaN(value[i])) continue;
                if (out == null) {
                    out = Arrays.copyOf(value, value.length);
                }
                out[i] = context.getFloat(Utils.idFromNan(value[i]));
            }
            this.mUniformFloatMap.put(name, out == null ? value : out);
        }
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (this.mUniformFloatMap == null) {
            return;
        }
        for (String name : this.mUniformRawFloatMap.keySet()) {
            float[] value;
            for (float v : value = this.mUniformRawFloatMap.get(name)) {
                if (!Float.isNaN(v)) continue;
                context.listensTo(Utils.idFromNan(v), this);
            }
        }
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 45;
    }

    public static void apply(@NonNull WireBuffer buffer, int shaderID, int shaderTextId, @Nullable HashMap<String, float[]> floatMap, @Nullable HashMap<String, int[]> intMap, @Nullable HashMap<String, Integer> bitmapMap) {
        Object[] values;
        buffer.start(45);
        buffer.writeInt(shaderID);
        buffer.writeInt(shaderTextId);
        int floatSize = floatMap == null ? 0 : floatMap.size();
        int intSize = intMap == null ? 0 : intMap.size();
        int bitmapSize = bitmapMap == null ? 0 : bitmapMap.size();
        int sizes = floatSize | intSize << 8 | bitmapSize << 16;
        buffer.writeInt(sizes);
        if (floatSize > 0) {
            for (String name : floatMap.keySet()) {
                buffer.writeUTF8(name);
                values = floatMap.get(name);
                buffer.writeInt(values.length);
                for (float value : values) {
                    buffer.writeFloat(value);
                }
            }
        }
        if (intSize > 0) {
            for (String name : intMap.keySet()) {
                buffer.writeUTF8(name);
                values = intMap.get(name);
                buffer.writeInt(values.length);
                for (float value : values) {
                    buffer.writeInt((int)value);
                }
            }
        }
        if (bitmapSize > 0) {
            for (String name : bitmapMap.keySet()) {
                buffer.writeUTF8(name);
                int value = bitmapMap.get(name);
                buffer.writeInt(value);
            }
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int bitmapMapSize;
        int intMapSize;
        int shaderID = buffer.readInt();
        int shaderTextId = buffer.readInt();
        HashMap<String, float[]> floatMap = null;
        HashMap<String, int[]> intMap = null;
        HashMap<String, Integer> bitmapMap = null;
        int sizes = buffer.readInt();
        int floatMapSize = sizes & 0xFF;
        if (floatMapSize > 0) {
            floatMap = new HashMap<String, float[]>();
            for (int i = 0; i < floatMapSize; ++i) {
                String name = buffer.readUTF8();
                int len = buffer.readInt();
                float[] val = new float[len];
                for (int j = 0; j < len; ++j) {
                    val[j] = buffer.readFloat();
                }
                floatMap.put(name, val);
            }
        }
        if ((intMapSize = sizes >> 8 & 0xFF) > 0) {
            intMap = new HashMap<String, int[]>();
            for (int i = 0; i < intMapSize; ++i) {
                String name = buffer.readUTF8();
                int len = buffer.readInt();
                int[] val = new int[len];
                for (int j = 0; j < len; ++j) {
                    val[j] = buffer.readInt();
                }
                intMap.put(name, val);
            }
        }
        if ((bitmapMapSize = sizes >> 16 & 0xFF) > 0) {
            bitmapMap = new HashMap<String, Integer>();
            for (int i = 0; i < bitmapMapSize; ++i) {
                String name = buffer.readUTF8();
                int val = buffer.readInt();
                bitmapMap.put(name, val);
            }
        }
        operations.add(new ShaderData(shaderID, shaderTextId, floatMap, intMap, bitmapMap));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 45, CLASS_NAME).description("Shader").field(0, "shaderID", "id of shader").field(6, " floatSize", "number of float uniforms").field(6, " intSize", "number of int uniform").field(9, " intSize", "number of int uniform").field(5, "floatName", "name of float uniform").field(0, "length", "length").field(10, "VALUE", "float uniform (max 4)").field(5, "IntName", "id of shader text").field(0, "length", "length of uniform").field(11, "VALUE", "int uniform (max 4)").field(5, "bitmapName", "name of bitmap").field(0, "VALUE", "id of bitmap");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        if (this.mShaderValid) {
            context.loadShader(this.mShaderID, this);
        }
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    public void enable(boolean shaderValid) {
        this.mShaderValid = shaderValid;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("shaderTextId", this.mShaderTextId).add("shaderID", this.mShaderID).add("uniformRawFloatMap", this.mUniformRawFloatMap).add("uniformFloatMap", this.mUniformFloatMap).add("uniformBitmapMap", this.mUniformBitmapMap);
    }
}

