/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteComposeOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.semantics.AccessibleComponent;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class RootContentDescription
extends Operation
implements RemoteComposeOperation,
AccessibleComponent,
Serializable {
    private static final int OP_CODE = 103;
    private static final String CLASS_NAME = "RootContentDescription";
    int mContentDescription;

    public RootContentDescription(int contentDescription) {
        this.mContentDescription = contentDescription;
    }

    @Override
    public boolean isInterestingForSemantics() {
        return this.mContentDescription != 0;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        RootContentDescription.apply(buffer, this.mContentDescription);
    }

    @NonNull
    public String toString() {
        return "RootContentDescription " + this.mContentDescription;
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.setDocumentContentDescription(this.mContentDescription);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return this.toString();
    }

    @Override
    public Integer getContentDescriptionId() {
        return this.mContentDescription;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 103;
    }

    public static void apply(@NonNull WireBuffer buffer, int contentDescription) {
        buffer.start(103);
        buffer.writeInt(contentDescription);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int contentDescription = buffer.readInt();
        RootContentDescription header = new RootContentDescription(contentDescription);
        operations.add(header);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Protocol Operations", 103, CLASS_NAME).description("Content description of root").field(0, "id", "id of Int");
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("contentDescriptionId", this.mContentDescription);
    }
}

