/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.DrawBase3;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class DrawCircle
extends DrawBase3 {
    private static final int OP_CODE = 46;
    private static final String CLASS_NAME = "DrawCircle";

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        DrawBase3.Maker m = DrawCircle::new;
        DrawCircle.read(m, buffer, operations);
    }

    public static int id() {
        return 46;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Canvas Operations", 46, CLASS_NAME).description("Draw a Circle").field(1, "centerX", "The x-coordinate of the center of the circle to be drawn").field(1, "centerY", "The y-coordinate of the center of the circle to be drawn").field(1, "radius", "The radius of the circle to be drawn");
    }

    @Override
    protected void write(@NonNull WireBuffer buffer, float v1, float v2, float v3) {
        DrawCircle.apply(buffer, v1, v2, v3);
    }

    public DrawCircle(float left, float top, float right) {
        super(left, top, right);
        this.mName = CLASS_NAME;
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.drawCircle(this.mV1, this.mV2, this.mV3);
    }

    public static void apply(@NonNull WireBuffer buffer, float x1, float y1, float x2) {
        buffer.start(46);
        buffer.writeFloat(x1);
        buffer.writeFloat(y1);
        buffer.writeFloat(x2);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        this.serialize(serializer, "cx", "cy", "radius").addType(CLASS_NAME);
    }
}

