/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.semantics.AccessibleComponent;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class DrawBitmapInt
extends PaintOperation
implements AccessibleComponent {
    private static final int OP_CODE = 66;
    private static final String CLASS_NAME = "DrawBitmapInt";
    int mImageId;
    int mSrcLeft;
    int mSrcTop;
    int mSrcRight;
    int mSrcBottom;
    int mDstLeft;
    int mDstTop;
    int mDstRight;
    int mDstBottom;
    int mContentDescId = 0;

    public DrawBitmapInt(int imageId, int srcLeft, int srcTop, int srcRight, int srcBottom, int dstLeft, int dstTop, int dstRight, int dstBottom, int cdId) {
        this.mImageId = imageId;
        this.mSrcLeft = srcLeft;
        this.mSrcTop = srcTop;
        this.mSrcRight = srcRight;
        this.mSrcBottom = srcBottom;
        this.mDstLeft = dstLeft;
        this.mDstTop = dstTop;
        this.mDstRight = dstRight;
        this.mDstBottom = dstBottom;
        this.mContentDescId = cdId;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DrawBitmapInt.apply(buffer, this.mImageId, this.mSrcLeft, this.mSrcTop, this.mSrcRight, this.mSrcBottom, this.mDstLeft, this.mDstTop, this.mDstRight, this.mDstBottom, this.mContentDescId);
    }

    @NonNull
    public String toString() {
        return "DRAW_BITMAP_INT " + this.mImageId + " on " + this.mSrcLeft + " " + this.mSrcTop + " " + this.mSrcRight + " " + this.mSrcBottom + " - " + this.mDstLeft + " " + this.mDstTop + " " + this.mDstRight + " " + this.mDstBottom + ";";
    }

    @Override
    public Integer getContentDescriptionId() {
        return this.mContentDescId;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 66;
    }

    public static void apply(@NonNull WireBuffer buffer, int imageId, int srcLeft, int srcTop, int srcRight, int srcBottom, int dstLeft, int dstTop, int dstRight, int dstBottom, int cdId) {
        buffer.start(66);
        buffer.writeInt(imageId);
        buffer.writeInt(srcLeft);
        buffer.writeInt(srcTop);
        buffer.writeInt(srcRight);
        buffer.writeInt(srcBottom);
        buffer.writeInt(dstLeft);
        buffer.writeInt(dstTop);
        buffer.writeInt(dstRight);
        buffer.writeInt(dstBottom);
        buffer.writeInt(cdId);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int imageId = buffer.readInt();
        int sLeft = buffer.readInt();
        int srcTop = buffer.readInt();
        int srcRight = buffer.readInt();
        int srcBottom = buffer.readInt();
        int dstLeft = buffer.readInt();
        int dstTop = buffer.readInt();
        int dstRight = buffer.readInt();
        int dstBottom = buffer.readInt();
        int cdId = buffer.readInt();
        DrawBitmapInt op = new DrawBitmapInt(imageId, sLeft, srcTop, srcRight, srcBottom, dstLeft, dstTop, dstRight, dstBottom, cdId);
        operations.add(op);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Draw Operations", 66, CLASS_NAME).description("Draw a bitmap using integer coordinates").field(0, "id", "id of bitmap").field(0, "srcLeft", "The left side of the image").field(0, "srcTop", "The top of the image").field(0, "srcRight", "The right side of the image").field(0, "srcBottom", "The bottom of the image").field(0, "dstLeft", "The left side of the image").field(0, "dstTop", "The top of the image").field(0, "dstRight", "The right side of the image").field(0, "dstBottom", "The bottom of the image").field(0, "cdId", "id of string");
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.drawBitmap(this.mImageId, this.mSrcLeft, this.mSrcTop, this.mSrcRight, this.mSrcBottom, this.mDstLeft, this.mDstTop, this.mDstRight, this.mDstBottom, this.mContentDescId);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("imageId", this.mImageId).add("contentDescriptionId", this.mContentDescId).add("srcLeft", this.mSrcLeft).add("srcTop", this.mSrcTop).add("srcRight", this.mSrcRight).add("srcBottom", this.mSrcBottom).add("dstLeft", this.mDstLeft).add("dstTop", this.mDstTop).add("dstRight", this.mDstRight).add("dstBottom", this.mDstBottom);
    }
}

