/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public abstract class DrawBase4
extends PaintOperation
implements VariableSupport,
Serializable {
    @NonNull
    protected String mName = "DrawRectBase";
    protected float mX1;
    protected float mY1;
    protected float mX2;
    protected float mY2;
    float mX1Value;
    float mY1Value;
    float mX2Value;
    float mY2Value;

    public DrawBase4(float x1, float y1, float x2, float y2) {
        this.mX1Value = x1;
        this.mY1Value = y1;
        this.mX2Value = x2;
        this.mY2Value = y2;
        this.mX1 = x1;
        this.mY1 = y1;
        this.mX2 = x2;
        this.mY2 = y2;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        this.mX1 = Float.isNaN(this.mX1Value) ? context.getFloat(Utils.idFromNan(this.mX1Value)) : this.mX1Value;
        this.mY1 = Float.isNaN(this.mY1Value) ? context.getFloat(Utils.idFromNan(this.mY1Value)) : this.mY1Value;
        this.mX2 = Float.isNaN(this.mX2Value) ? context.getFloat(Utils.idFromNan(this.mX2Value)) : this.mX2Value;
        this.mY2 = Float.isNaN(this.mY2Value) ? context.getFloat(Utils.idFromNan(this.mY2Value)) : this.mY2Value;
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (Float.isNaN(this.mX1Value)) {
            context.listensTo(Utils.idFromNan(this.mX1Value), this);
        }
        if (Float.isNaN(this.mY1Value)) {
            context.listensTo(Utils.idFromNan(this.mY1Value), this);
        }
        if (Float.isNaN(this.mX2Value)) {
            context.listensTo(Utils.idFromNan(this.mX2Value), this);
        }
        if (Float.isNaN(this.mY2Value)) {
            context.listensTo(Utils.idFromNan(this.mY2Value), this);
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        this.write(buffer, this.mX1, this.mY1, this.mX2, this.mY2);
    }

    protected abstract void write(@NonNull WireBuffer var1, float var2, float var3, float var4, float var5);

    @NonNull
    public String toString() {
        return this.mName + " " + Utils.floatToString(this.mX1Value, this.mX1) + " " + Utils.floatToString(this.mY1Value, this.mY1) + " " + Utils.floatToString(this.mX2Value, this.mX2) + " " + Utils.floatToString(this.mY2Value, this.mY2);
    }

    public static void read(@NonNull Maker maker, @NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        float v1 = buffer.readFloat();
        float v2 = buffer.readFloat();
        float v3 = buffer.readFloat();
        float v4 = buffer.readFloat();
        DrawBase4 op = maker.create(v1, v2, v3, v4);
        operations.add(op);
    }

    @Nullable
    public Operation construct(float x1, float y1, float x2, float y2) {
        return null;
    }

    protected static void write(@NonNull WireBuffer buffer, int opCode, float x1, float y1, float x2, float y2) {
        buffer.start(opCode);
        buffer.writeFloat(x1);
        buffer.writeFloat(y1);
        buffer.writeFloat(x2);
        buffer.writeFloat(y2);
    }

    protected MapSerializer serialize(MapSerializer serializer, String x1Name, String y1Name, String x2Name, String y2Name) {
        return serializer.add(x1Name, this.mX1Value, this.mX1).add(y1Name, this.mY1Value, this.mY1).add(x2Name, this.mX2Value, this.mX2).add(y2Name, this.mY2Value, this.mY2);
    }

    protected static interface Maker {
        public DrawBase4 create(float var1, float var2, float var3, float var4);
    }
}

