/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import java.util.List;

public class DebugMessage
extends Operation
implements VariableSupport {
    private static final int OP_CODE = 179;
    private static final String CLASS_NAME = "DebugMessage";
    int mTextID;
    float mFloatValue;
    float mOutFloatValue;
    int mFlags = 0;

    public DebugMessage(int textID, float value, int flags) {
        this.mTextID = textID;
        this.mFloatValue = value;
        this.mFlags = flags;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        System.out.println("Debug message : updateVariables ");
        this.mOutFloatValue = Float.isNaN(this.mFloatValue) ? context.getFloat(Utils.idFromNan(this.mFloatValue)) : this.mFloatValue;
        System.out.println("Debug message : updateVariables " + Utils.floatToString(this.mFloatValue, this.mOutFloatValue));
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        System.out.println("Debug message : registerListening ");
        if (Float.isNaN(this.mFloatValue)) {
            System.out.println("Debug message : registerListening " + this.mFloatValue);
            context.listensTo(Utils.idFromNan(this.mFloatValue), this);
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DebugMessage.apply(buffer, this.mTextID, this.mFloatValue, this.mFlags);
    }

    @NonNull
    public String toString() {
        return "DebugMessage " + this.mTextID + ", " + Utils.floatToString(this.mFloatValue, this.mOutFloatValue) + ", " + this.mFlags;
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int text = buffer.readInt();
        float floatValue = buffer.readFloat();
        int flags = buffer.readInt();
        DebugMessage op = new DebugMessage(text, floatValue, flags);
        operations.add(op);
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 179;
    }

    public static void apply(@NonNull WireBuffer buffer, int textID, float value, int flags) {
        buffer.start(179);
        buffer.writeInt(textID);
        buffer.writeFloat(value);
        buffer.writeInt(flags);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("DebugMessage Operations", DebugMessage.id(), CLASS_NAME).description("Print debugging messages").field(0, "textId", "test to print").field(1, "value", "value of a float to print").field(0, "flags", "print additional information");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        String str = context.getText(this.mTextID);
        System.out.println("Debug message : " + str + " " + this.mOutFloatValue + " " + this.mFlags);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }
}

