/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.utilities.ArrayAccess;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.Arrays;
import java.util.List;

public class DataListIds
extends Operation
implements VariableSupport,
ArrayAccess,
Serializable {
    private static final int OP_CODE = 146;
    private static final String CLASS_NAME = "IdListData";
    private final int mId;
    @NonNull
    private final int[] mIds;
    private static final int MAX_LIST = 2000;

    public DataListIds(int id2, @NonNull int[] ids) {
        this.mId = id2;
        this.mIds = ids;
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        DataListIds.apply(buffer, this.mId, this.mIds);
    }

    @NonNull
    public String toString() {
        return "map[" + Utils.idString(this.mId) + "]  \"" + Arrays.toString(this.mIds) + "\"";
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, @NonNull int[] ids) {
        buffer.start(146);
        buffer.writeInt(id2);
        buffer.writeInt(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            buffer.writeInt(ids[i]);
        }
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int len = buffer.readInt();
        if (len > 2000) {
            throw new RuntimeException(len + " list entries more than max = " + 2000);
        }
        int[] ids = new int[len];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = buffer.readInt();
        }
        DataListIds data = new DataListIds(id2, ids);
        operations.add(data);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Data Operations", 146, CLASS_NAME).description("a list of id's").field(0, "id", "id the array").field(0, "length", "number of ids").field(11, "ids[n]", "length", "ids of other variables");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.addCollection(this.mId, this);
    }

    @Override
    public float getFloatValue(int index) {
        return Float.NaN;
    }

    @Override
    public int getId(int index) {
        return this.mIds[index];
    }

    @Override
    @Nullable
    public float[] getFloats() {
        return null;
    }

    @Override
    public int getLength() {
        return this.mIds.length;
    }

    @Override
    public int getIntValue(int index) {
        return 0;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("ids", List.of(this.mIds));
    }
}

