/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.documentation;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.documentation.OperationField;
import com.android.internal.widget.remotecompose.core.documentation.StringPair;
import java.util.ArrayList;

public class DocumentedOperation {
    public static final int LAYOUT = 0;
    public static final int INT = 0;
    public static final int FLOAT = 1;
    public static final int BOOLEAN = 2;
    public static final int BUFFER = 4;
    public static final int UTF8 = 5;
    public static final int BYTE = 6;
    public static final int VALUE = 7;
    public static final int LONG = 8;
    public static final int SHORT = 9;
    public static final int FLOAT_ARRAY = 10;
    public static final int INT_ARRAY = 11;
    @NonNull
    final String mCategory;
    int mId;
    @NonNull
    final String mName;
    @NonNull
    String mDescription = "";
    boolean mWIP;
    @Nullable
    String mTextExamples;
    @NonNull
    ArrayList<StringPair> mExamples = new ArrayList();
    @NonNull
    ArrayList<OperationField> mFields = new ArrayList();
    @NonNull
    String mVarSize = "";
    int mExamplesWidth = 100;
    int mExamplesHeight = 100;

    @NonNull
    public static String getType(int type) {
        switch (type) {
            case 0: {
                return "INT";
            }
            case 1: {
                return "FLOAT";
            }
            case 2: {
                return "BOOLEAN";
            }
            case 4: {
                return "BUFFER";
            }
            case 5: {
                return "UTF8";
            }
            case 6: {
                return "BYTE";
            }
            case 7: {
                return "VALUE";
            }
            case 8: {
                return "LONG";
            }
            case 9: {
                return "SHORT";
            }
            case 10: {
                return "FLOAT[]";
            }
            case 11: {
                return "INT[]";
            }
        }
        return "UNKNOWN";
    }

    public DocumentedOperation(@NonNull String category, int id2, @NonNull String name, boolean wip) {
        this.mCategory = category;
        this.mId = id2;
        this.mName = name;
        this.mWIP = wip;
    }

    public DocumentedOperation(@NonNull String category, int id2, @NonNull String name) {
        this(category, id2, name, false);
    }

    @NonNull
    public ArrayList<OperationField> getFields() {
        return this.mFields;
    }

    @NonNull
    public String getCategory() {
        return this.mCategory;
    }

    public int getId() {
        return this.mId;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    public boolean isWIP() {
        return this.mWIP;
    }

    @NonNull
    public String getVarSize() {
        return this.mVarSize;
    }

    public int getSizeFields() {
        int size = 0;
        this.mVarSize = "";
        for (OperationField field : this.mFields) {
            size += Math.max(0, field.getSize());
            if (field.getSize() >= 0) continue;
            this.mVarSize = this.mVarSize + " + " + field.getVarSize() + " x 4";
        }
        return size;
    }

    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    @Nullable
    public String getTextExamples() {
        return this.mTextExamples;
    }

    @NonNull
    public ArrayList<StringPair> getExamples() {
        return this.mExamples;
    }

    public int getExamplesWidth() {
        return this.mExamplesWidth;
    }

    public int getExamplesHeight() {
        return this.mExamplesHeight;
    }

    @NonNull
    public DocumentedOperation field(int type, @NonNull String name, @NonNull String description) {
        this.mFields.add(new OperationField(type, name, description));
        return this;
    }

    @NonNull
    public DocumentedOperation field(int type, @NonNull String name, @NonNull String varSize, @NonNull String description) {
        this.mFields.add(new OperationField(type, name, varSize, description));
        return this;
    }

    @NonNull
    public DocumentedOperation possibleValues(@NonNull String name, int value) {
        if (!this.mFields.isEmpty()) {
            this.mFields.get(this.mFields.size() - 1).possibleValue(name, "" + value);
        }
        return this;
    }

    @NonNull
    public DocumentedOperation description(@NonNull String description) {
        this.mDescription = description;
        return this;
    }

    @NonNull
    public DocumentedOperation examples(@NonNull String examples) {
        this.mTextExamples = examples;
        return this;
    }

    @NonNull
    public DocumentedOperation exampleImage(@NonNull String name, @NonNull String imagePath) {
        this.mExamples.add(new StringPair(name, imagePath));
        return this;
    }

    @NonNull
    public DocumentedOperation examplesDimension(int width, int height) {
        this.mExamplesWidth = width;
        this.mExamplesHeight = height;
        return this;
    }
}

