/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.CoreDocument;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;

public class TimeVariables {
    public void updateTime(@NonNull RemoteContext context, ZoneId zoneId, LocalDateTime dateTime) {
        int month = dateTime.getMonth().getValue();
        int hour = dateTime.getHour();
        int minute = dateTime.getMinute();
        int seconds = dateTime.getSecond();
        int currentMinute = hour * 60 + minute;
        int currentSeconds = minute * 60 + seconds;
        float sec = (float)currentSeconds + (float)dateTime.getNano() * 1.0E-9f;
        int day_week = dateTime.getDayOfWeek().getValue();
        OffsetDateTime offsetDateTime = dateTime.atZone(zoneId).toOffsetDateTime();
        ZoneOffset offset = offsetDateTime.getOffset();
        long epochSec = dateTime.toEpochSecond(offset);
        context.loadFloat(10, offset.getTotalSeconds());
        context.loadFloat(1, sec);
        context.loadInteger(32, (int)epochSec);
        context.loadFloat(2, currentSeconds);
        context.loadFloat(3, currentMinute);
        context.loadFloat(4, hour);
        context.loadFloat(9, month);
        context.loadFloat(12, month);
        context.loadFloat(11, day_week);
        context.loadFloat(28, (float)CoreDocument.getDocumentApiLevel() + 0.0f);
    }

    public void updateTime(@NonNull RemoteContext context) {
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime dateTime = LocalDateTime.now(zone);
        this.updateTime(context, zone, dateTime);
    }
}

