/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.lang.System_Delegate;
import com.android.internal.widget.remotecompose.core.CoreDocument;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteComposeState;
import com.android.internal.widget.remotecompose.core.TouchListener;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.operations.FloatExpression;
import com.android.internal.widget.remotecompose.core.operations.ShaderData;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.utilities.ArrayAccess;
import com.android.internal.widget.remotecompose.core.operations.utilities.CollectionsAccess;
import com.android.internal.widget.remotecompose.core.operations.utilities.DataMap;
import com.android.internal.widget.remotecompose.core.operations.utilities.IntMap;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;

public abstract class RemoteContext {
    private static final int MAX_OP_COUNT = 20000;
    @NonNull
    protected CoreDocument mDocument = new CoreDocument();
    @NonNull
    public RemoteComposeState mRemoteComposeState = new RemoteComposeState();
    private long mDocLoadTime = System_Delegate.currentTimeMillis();
    @Nullable
    protected PaintContext mPaintContext = null;
    protected float mDensity = Float.NaN;
    @NonNull
    ContextMode mMode = ContextMode.UNSET;
    int mDebug = 0;
    private int mOpCount;
    private int mTheme = -1;
    public float mWidth = 0.0f;
    public float mHeight = 0.0f;
    private float mAnimationTime;
    private boolean mAnimate = true;
    @Nullable
    public Component mLastComponent;
    public long currentTime = 0L;
    private boolean mUseChoreographer = true;
    public static final int ID_CONTINUOUS_SEC = 1;
    public static final int ID_TIME_IN_SEC = 2;
    public static final int ID_TIME_IN_MIN = 3;
    public static final int ID_TIME_IN_HR = 4;
    public static final int ID_WINDOW_WIDTH = 5;
    public static final int ID_WINDOW_HEIGHT = 6;
    public static final int ID_COMPONENT_WIDTH = 7;
    public static final int ID_COMPONENT_HEIGHT = 8;
    public static final int ID_CALENDAR_MONTH = 9;
    public static final int ID_OFFSET_TO_UTC = 10;
    public static final int ID_WEEK_DAY = 11;
    public static final int ID_DAY_OF_MONTH = 12;
    public static final int ID_TOUCH_POS_X = 13;
    public static final int ID_TOUCH_POS_Y = 14;
    public static final int ID_TOUCH_VEL_X = 15;
    public static final int ID_TOUCH_VEL_Y = 16;
    public static final int ID_ACCELERATION_X = 17;
    public static final int ID_ACCELERATION_Y = 18;
    public static final int ID_ACCELERATION_Z = 19;
    public static final int ID_GYRO_ROT_X = 20;
    public static final int ID_GYRO_ROT_Y = 21;
    public static final int ID_GYRO_ROT_Z = 22;
    public static final int ID_MAGNETIC_X = 23;
    public static final int ID_MAGNETIC_Y = 24;
    public static final int ID_MAGNETIC_Z = 25;
    public static final int ID_LIGHT = 26;
    public static final int ID_DENSITY = 27;
    public static final int ID_API_LEVEL = 28;
    public static final int ID_TOUCH_EVENT_TIME = 29;
    public static final int ID_ANIMATION_TIME = 30;
    public static final int ID_ANIMATION_DELTA_TIME = 31;
    public static final int ID_EPOCH_SECOND = 32;
    public static final int ID_FONT_SIZE = 33;
    public static final float FLOAT_DENSITY = Utils.asNan(27);
    public static final float FLOAT_CONTINUOUS_SEC = Utils.asNan(1);
    public static final float FLOAT_TIME_IN_SEC = Utils.asNan(2);
    public static final float FLOAT_TIME_IN_MIN = Utils.asNan(3);
    public static final float FLOAT_TIME_IN_HR = Utils.asNan(4);
    public static final float FLOAT_CALENDAR_MONTH = Utils.asNan(9);
    public static final float FLOAT_WEEK_DAY = Utils.asNan(11);
    public static final float FLOAT_DAY_OF_MONTH = Utils.asNan(12);
    public static final float FLOAT_WINDOW_WIDTH = Utils.asNan(5);
    public static final float FLOAT_WINDOW_HEIGHT = Utils.asNan(6);
    public static final float FLOAT_COMPONENT_WIDTH = Utils.asNan(7);
    public static final float FLOAT_COMPONENT_HEIGHT = Utils.asNan(8);
    public static final float FLOAT_OFFSET_TO_UTC = Utils.asNan(10);
    public static final float FLOAT_TOUCH_POS_X = Utils.asNan(13);
    public static final float FLOAT_TOUCH_POS_Y = Utils.asNan(14);
    public static final float FLOAT_TOUCH_VEL_X = Utils.asNan(15);
    public static final float FLOAT_TOUCH_VEL_Y = Utils.asNan(16);
    public static final float FLOAT_TOUCH_EVENT_TIME = Utils.asNan(29);
    public static final float FLOAT_ANIMATION_TIME = Utils.asNan(30);
    public static final float FLOAT_ANIMATION_DELTA_TIME = Utils.asNan(31);
    public static final float FLOAT_ACCELERATION_X = Utils.asNan(17);
    public static final float FLOAT_ACCELERATION_Y = Utils.asNan(18);
    public static final float FLOAT_ACCELERATION_Z = Utils.asNan(19);
    public static final float FLOAT_GYRO_ROT_X = Utils.asNan(20);
    public static final float FLOAT_GYRO_ROT_Y = Utils.asNan(21);
    public static final float FLOAT_GYRO_ROT_Z = Utils.asNan(22);
    public static final float FLOAT_MAGNETIC_X = Utils.asNan(23);
    public static final float FLOAT_MAGNETIC_Y = Utils.asNan(24);
    public static final float FLOAT_MAGNETIC_Z = Utils.asNan(25);
    public static final float FLOAT_LIGHT = Utils.asNan(26);
    public static final float FLOAT_API_LEVEL = Utils.asNan(28);
    public static final float FLOAT_FONT_SIZE = Utils.asNan(33);
    public static final long INT_EPOCH_SECOND = 0x100000020L;

    public boolean supportsVersion(int major, int minor, int patch) {
        return this.mDocument.mVersion.supportsVersion(major, minor, patch);
    }

    public float getDensity() {
        return this.mDensity;
    }

    public void setDensity(float density) {
        if (!Float.isNaN(density) && density > 0.0f) {
            this.mDensity = density;
        }
    }

    public long getDocLoadTime() {
        return this.mDocLoadTime;
    }

    public void setDocLoadTime() {
        this.mDocLoadTime = System_Delegate.currentTimeMillis();
    }

    public boolean isAnimationEnabled() {
        return this.mAnimate;
    }

    public void setAnimationEnabled(boolean value) {
        this.mAnimate = value;
    }

    @Nullable
    public CollectionsAccess getCollectionsAccess() {
        return this.mRemoteComposeState;
    }

    public abstract void loadPathData(int var1, @NonNull float[] var2);

    @Nullable
    public abstract float[] getPathData(int var1);

    public abstract void loadVariableName(@NonNull String var1, int var2, int var3);

    public abstract void loadColor(int var1, int var2);

    public void setAnimationTime(float time) {
        this.mAnimationTime = time;
    }

    public float getAnimationTime() {
        return this.mAnimationTime;
    }

    public abstract void setNamedColorOverride(@NonNull String var1, int var2);

    public abstract void setNamedStringOverride(@NonNull String var1, @NonNull String var2);

    public abstract void clearNamedStringOverride(@NonNull String var1);

    public abstract void setNamedIntegerOverride(@NonNull String var1, int var2);

    public abstract void clearNamedIntegerOverride(@NonNull String var1);

    public abstract void setNamedFloatOverride(String var1, float var2);

    public abstract void clearNamedFloatOverride(String var1);

    public abstract void setNamedLong(String var1, long var2);

    public abstract void setNamedDataOverride(String var1, Object var2);

    public abstract void clearNamedDataOverride(String var1);

    public abstract void addCollection(int var1, @NonNull ArrayAccess var2);

    public abstract void putDataMap(int var1, @NonNull DataMap var2);

    @Nullable
    public abstract DataMap getDataMap(int var1);

    public abstract void runAction(int var1, @NonNull String var2);

    public abstract void runNamedAction(int var1, Object var2);

    public abstract void putObject(int var1, @NonNull Object var2);

    @Nullable
    public abstract Object getObject(int var1);

    public void addTouchListener(TouchListener touchExpression) {
    }

    public abstract void hapticEffect(int var1);

    public void needsRepaint() {
        if (this.mPaintContext != null) {
            this.mPaintContext.needsRepaint();
        }
    }

    public boolean useChoreographer() {
        return this.mUseChoreographer;
    }

    public void setUseChoreographer(boolean value) {
        this.mUseChoreographer = value;
    }

    public int getTheme() {
        return this.mTheme;
    }

    public void setTheme(int theme) {
        this.mTheme = theme;
    }

    @NonNull
    public ContextMode getMode() {
        return this.mMode;
    }

    public void setMode(@NonNull ContextMode mode) {
        this.mMode = mode;
    }

    @Nullable
    public PaintContext getPaintContext() {
        return this.mPaintContext;
    }

    public void setPaintContext(@NonNull PaintContext paintContext) {
        this.mPaintContext = paintContext;
    }

    @Nullable
    public CoreDocument getDocument() {
        return this.mDocument;
    }

    public boolean isDebug() {
        return this.mDebug == 1;
    }

    public boolean isVisualDebug() {
        return this.mDebug == 2;
    }

    public void setDebug(int debug) {
        this.mDebug = debug;
    }

    public void setDocument(@NonNull CoreDocument document) {
        this.mDocument = document;
    }

    public void header(int majorVersion, int minorVersion, int patchVersion, int width, int height, long capabilities, IntMap<Object> properties) {
        this.mRemoteComposeState.setWindowWidth(width);
        this.mRemoteComposeState.setWindowHeight(height);
        this.mDocument.setVersion(majorVersion, minorVersion, patchVersion);
        this.mDocument.setWidth(width);
        this.mDocument.setHeight(height);
        this.mDocument.setRequiredCapabilities(capabilities);
        this.mDocument.setProperties(properties);
    }

    public void setRootContentBehavior(int scroll, int alignment, int sizing, int mode) {
        this.mDocument.setRootContentBehavior(scroll, alignment, sizing, mode);
    }

    public void setDocumentContentDescription(int contentDescriptionId) {
        String contentDescription = (String)this.mRemoteComposeState.getFromId(contentDescriptionId);
        this.mDocument.setContentDescription(contentDescription);
    }

    public abstract void loadBitmap(int var1, short var2, short var3, int var4, int var5, @NonNull byte[] var6);

    public abstract void loadText(int var1, @NonNull String var2);

    @Nullable
    public abstract String getText(int var1);

    public abstract void loadFloat(int var1, float var2);

    public abstract void overrideFloat(int var1, float var2);

    public abstract void loadInteger(int var1, int var2);

    public abstract void overrideInteger(int var1, int var2);

    public abstract void overrideText(int var1, int var2);

    public abstract void loadAnimatedFloat(int var1, @NonNull FloatExpression var2);

    public abstract void loadShader(int var1, @NonNull ShaderData var2);

    public abstract float getFloat(int var1);

    public abstract int getInteger(int var1);

    public abstract long getLong(int var1);

    public abstract int getColor(int var1);

    public abstract void listensTo(int var1, @NonNull VariableSupport var2);

    public abstract int updateOps();

    @Nullable
    public abstract ShaderData getShader(int var1);

    public static boolean isTime(float fl) {
        int value = Utils.idFromNan(fl);
        return value >= 1 && value <= 12;
    }

    public static float getTime(float fl) {
        LocalDateTime dateTime = LocalDateTime.now(ZoneId.systemDefault());
        int value = Utils.idFromNan(fl);
        int month = dateTime.getMonth().getValue();
        int hour = dateTime.getHour();
        int minute = dateTime.getMinute();
        int seconds = dateTime.getSecond();
        int currentMinute = hour * 60 + minute;
        int currentSeconds = minute * 60 + seconds;
        float sec = (float)currentSeconds + (float)dateTime.getNano() * 1.0E-9f;
        int day_week = dateTime.getDayOfWeek().getValue();
        ZoneId zone = ZoneId.systemDefault();
        OffsetDateTime offsetDateTime = dateTime.atZone(zone).toOffsetDateTime();
        ZoneOffset offset = offsetDateTime.getOffset();
        switch (value) {
            case 10: {
                return offset.getTotalSeconds();
            }
            case 1: {
                return sec;
            }
            case 2: {
                return currentSeconds;
            }
            case 3: {
                return currentMinute;
            }
            case 4: {
                return hour;
            }
            case 9: 
            case 12: {
                return month;
            }
            case 11: {
                return day_week;
            }
        }
        return fl;
    }

    public abstract void addClickArea(int var1, int var2, float var3, float var4, float var5, float var6, int var7);

    public void incrementOpCount() {
        ++this.mOpCount;
        if (this.mOpCount > 20000) {
            throw new RuntimeException("Too many operations executed");
        }
    }

    public int getLastOpCount() {
        int count = this.mOpCount;
        this.mOpCount = 0;
        return count;
    }

    public void clearLastOpCount() {
        this.mOpCount = 0;
    }

    public static enum ContextMode {
        UNSET,
        DATA,
        PAINT;

    }
}

