/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.accessibility;

import android.annotation.Nullable;
import android.graphics.PointF;
import android.os.Bundle;
import com.android.internal.widget.remotecompose.accessibility.RemoteComposeDocumentAccessibility;
import com.android.internal.widget.remotecompose.core.CoreDocument;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.RootLayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ComponentModifiers;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ModifierOperation;
import com.android.internal.widget.remotecompose.core.semantics.AccessibilitySemantics;
import com.android.internal.widget.remotecompose.core.semantics.AccessibleComponent;
import com.android.internal.widget.remotecompose.core.semantics.ScrollableComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CoreDocumentAccessibility
implements RemoteComposeDocumentAccessibility {
    private final CoreDocument mDocument;
    private final RemoteContext mRemoteContext;

    public CoreDocumentAccessibility(CoreDocument document, RemoteContext remoteContext) {
        this.mDocument = document;
        this.mRemoteContext = remoteContext;
    }

    @Override
    @Nullable
    public Integer getComponentIdAt(PointF point) {
        return RootId;
    }

    @Override
    @Nullable
    public Component findComponentById(int virtualViewId) {
        RootLayoutComponent root = this.mDocument.getRootLayoutComponent();
        if (root == null || virtualViewId == -1) {
            return root;
        }
        return CoreDocumentAccessibility.componentStream(root).filter(op -> op.getComponentId() == virtualViewId).findFirst().orElse(null);
    }

    @Override
    public AccessibleComponent.Mode mergeMode(Component component) {
        if (!(component instanceof LayoutComponent)) {
            return AccessibleComponent.Mode.SET;
        }
        AccessibleComponent.Mode result = AccessibleComponent.Mode.SET;
        for (ModifierOperation modifier : ((LayoutComponent)component).getComponentModifiers().getList()) {
            AccessibleComponent semantics;
            if (!(modifier instanceof AccessibleComponent) || (semantics = (AccessibleComponent)((Object)modifier)).getMode().ordinal() <= result.ordinal()) continue;
            result = semantics.getMode();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performAction(Component component, int action, Bundle arguments) {
        boolean needsRepaint = true;
        try {
            if (CoreDocumentAccessibility.isClickAction(action)) {
                boolean bl = this.performClick(component);
                return bl;
            }
            if (CoreDocumentAccessibility.isScrollForwardAction(action)) {
                boolean bl = this.scrollDirection(this.mRemoteContext, component, ScrollableComponent.ScrollDirection.FORWARD);
                return bl;
            }
            if (CoreDocumentAccessibility.isScrollBackwardAction(action)) {
                boolean bl = this.scrollDirection(this.mRemoteContext, component, ScrollableComponent.ScrollDirection.BACKWARD);
                return bl;
            }
            if (CoreDocumentAccessibility.isShowOnScreenAction(action)) {
                boolean bl = this.showOnScreen(this.mRemoteContext, component);
                return bl;
            }
            needsRepaint = false;
            boolean bl = false;
            return bl;
        }
        finally {
            if (needsRepaint) {
                this.mDocument.needsRepaint();
            }
        }
    }

    private static boolean isShowOnScreenAction(int action) {
        return action == 16908342;
    }

    private static boolean isScrollBackwardAction(int action) {
        return action == 8192 || action == 16908344 || action == 16908345;
    }

    private static boolean isScrollForwardAction(int action) {
        return action == 4096 || action == 16908346 || action == 16908347;
    }

    private static boolean isClickAction(int action) {
        return action == 16;
    }

    private boolean showOnScreen(RemoteContext context, Component component) {
        ScrollableComponent scrollable = CoreDocumentAccessibility.findScrollable(component);
        if (scrollable != null) {
            return scrollable.showOnScreen(context, component);
        }
        return false;
    }

    @Nullable
    private static ScrollableComponent findScrollable(Component component) {
        for (Component parent = component.getParent(); parent != null; parent = parent.getParent()) {
            ScrollableComponent scrollable = parent.selfOrModifier(ScrollableComponent.class);
            if (scrollable == null) continue;
            return scrollable;
        }
        return null;
    }

    public int scrollByOffset(RemoteContext context, Component component, int pixels) {
        ScrollableComponent scrollable = component.selfOrModifier(ScrollableComponent.class);
        if (scrollable != null) {
            return scrollable.scrollByOffset(context, pixels);
        }
        return 0;
    }

    public boolean scrollDirection(RemoteContext context, Component component, ScrollableComponent.ScrollDirection direction) {
        ScrollableComponent scrollable = component.selfOrModifier(ScrollableComponent.class);
        if (scrollable != null) {
            return scrollable.scrollDirection(context, direction);
        }
        return false;
    }

    public boolean performClick(Component component) {
        this.mDocument.performClick(this.mRemoteContext, component.getComponentId(), "");
        return true;
    }

    @Override
    @Nullable
    public String stringValue(int id2) {
        Object value = this.mDocument.getRemoteComposeState().getFromId(id2);
        return value != null ? String.valueOf(value) : null;
    }

    @Override
    public List<AccessibilitySemantics> semanticModifiersForComponent(Component component) {
        if (!(component instanceof LayoutComponent)) {
            return Collections.emptyList();
        }
        ArrayList<ModifierOperation> modifiers = ((LayoutComponent)component).getComponentModifiers().getList();
        return modifiers.stream().filter(it -> it instanceof AccessibilitySemantics && ((AccessibilitySemantics)((Object)it)).isInterestingForSemantics()).map(i -> (AccessibilitySemantics)((Object)i)).collect(Collectors.toList());
    }

    @Override
    public List<Integer> semanticallyRelevantChildComponents(Component component, boolean useUnmergedTree) {
        if (!component.isVisible()) {
            return Collections.emptyList();
        }
        AccessibleComponent.Mode mergeMode = this.mergeMode(component);
        if (mergeMode == AccessibleComponent.Mode.CLEAR_AND_SET || !useUnmergedTree && mergeMode == AccessibleComponent.Mode.MERGE) {
            return Collections.emptyList();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Operation child : component.mList) {
            if (!(child instanceof Component)) continue;
            if (CoreDocumentAccessibility.isInteresting((Component)child)) {
                result.add(((Component)child).getComponentId());
                continue;
            }
            result.addAll(this.semanticallyRelevantChildComponents((Component)child, useUnmergedTree));
        }
        return result;
    }

    static Stream<Component> componentStream(Component root) {
        return Stream.concat(Stream.of(root), root.mList.stream().flatMap(op -> {
            if (op instanceof Component) {
                return CoreDocumentAccessibility.componentStream((Component)op);
            }
            return Stream.empty();
        }));
    }

    static Stream<ModifierOperation> modifiersStream(Component component) {
        return component.mList.stream().filter(it -> it instanceof ComponentModifiers).flatMap(it -> ((ComponentModifiers)it).getList().stream());
    }

    static boolean isInteresting(Component component) {
        if (!component.isVisible()) {
            return false;
        }
        return CoreDocumentAccessibility.isContainerWithSemantics(component) || CoreDocumentAccessibility.modifiersStream(component).anyMatch(CoreDocumentAccessibility::isModifierWithSemantics);
    }

    static boolean isModifierWithSemantics(ModifierOperation modifier) {
        return modifier instanceof AccessibilitySemantics && ((AccessibilitySemantics)((Object)modifier)).isInterestingForSemantics();
    }

    static boolean isContainerWithSemantics(Component component) {
        if (component instanceof AccessibilitySemantics) {
            return ((AccessibilitySemantics)((Object)component)).isInterestingForSemantics();
        }
        if (!(component instanceof LayoutComponent)) {
            return false;
        }
        return ((LayoutComponent)component).getComponentModifiers().getList().stream().anyMatch(CoreDocumentAccessibility::isModifierWithSemantics);
    }
}

