/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.floatingtoolbar;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.MenuItem;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.selectiontoolbar.ISelectionToolbarCallback;
import android.view.selectiontoolbar.SelectionToolbarManager;
import android.view.selectiontoolbar.ShowInfo;
import android.view.selectiontoolbar.ToolbarMenuItem;
import android.view.selectiontoolbar.WidgetInfo;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import com.android.internal.widget.floatingtoolbar.FloatingToolbarPopup;
import com.android.internal.widget.floatingtoolbar.LocalFloatingToolbarPopup;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class RemoteFloatingToolbarPopup
implements FloatingToolbarPopup {
    private static final boolean DEBUG = Log.isLoggable("floating_toolbar", 2);
    private static final int TOOLBAR_STATE_SHOWN = 1;
    private static final int TOOLBAR_STATE_HIDDEN = 2;
    private static final int TOOLBAR_STATE_DISMISSED = 3;
    @NonNull
    private final Context mContext;
    @NonNull
    private final SelectionToolbarManager mSelectionToolbarManager;
    @NonNull
    private final View mParent;
    @NonNull
    private final PopupWindow mPopupWindow;
    @NonNull
    private final SelectionToolbarCallbackImpl mSelectionToolbarCallback;
    private int mState;
    private int mNextSequenceNumber;
    private final SparseArray<MenuItem.OnMenuItemClickListener> mPendingMenuItemClickListeners = new SparseArray();
    private final SparseArray<List<MenuItem>> mPendingMenuItems = new SparseArray();
    private final SparseArray<ShowInfo> mPendingShowInfos = new SparseArray();
    private final Rect mContentRect = new Rect();
    private List<MenuItem> mMenuItems;
    private MenuItem.OnMenuItemClickListener mMenuItemClickListener;
    private long mFloatingToolbarToken;
    private int mSuggestedWidth;
    private final Rect mScreenViewPort = new Rect();
    private boolean mWidthChanged = true;
    private final boolean mIsLightTheme;
    private final int[] mCoordsOnScreen = new int[2];
    private final int[] mCoordsOnWindow = new int[2];

    public RemoteFloatingToolbarPopup(Context context, View parent) {
        this.mContext = context;
        this.mParent = Objects.requireNonNull(parent);
        this.mPopupWindow = RemoteFloatingToolbarPopup.createPopupWindow(context);
        this.mSelectionToolbarManager = context.getSystemService(SelectionToolbarManager.class);
        this.mSelectionToolbarCallback = new SelectionToolbarCallbackImpl(this);
        this.mIsLightTheme = this.isLightTheme(context);
        this.mFloatingToolbarToken = 0L;
    }

    private boolean isLightTheme(Context context) {
        TypedArray a = context.obtainStyledAttributes(new int[]{16844176});
        boolean isLightTheme = a.getBoolean(0, true);
        a.recycle();
        return isLightTheme;
    }

    @Override
    public void show(List<MenuItem> menuItems, MenuItem.OnMenuItemClickListener menuItemClickListener, Rect contentRect) {
        boolean isLayoutRequired;
        Objects.requireNonNull(menuItems);
        Objects.requireNonNull(menuItemClickListener);
        ViewRootImpl viewRootImpl = this.mParent.getViewRootImpl();
        if (viewRootImpl == null) {
            Log.w("floating_toolbar", "RemoteFloatingToolbarPopup.show(): viewRootImpl is null.");
            return;
        }
        if (this.isShowing() && Objects.equals(menuItems, this.mMenuItems) && Objects.equals(contentRect, this.mContentRect)) {
            if (DEBUG) {
                Log.v("floating_toolbar", "Ignore duplicate show() for the same content.");
            }
            return;
        }
        if (this.isLatestPendingOrCurrent(menuItems, menuItemClickListener, contentRect)) {
            return;
        }
        boolean bl = isLayoutRequired = this.mMenuItems == null || !MenuItemRepr.reprEquals(menuItems, this.mMenuItems) || this.mWidthChanged;
        if (isLayoutRequired) {
            this.mSelectionToolbarManager.dismissToolbar(this.mFloatingToolbarToken);
            this.doDismissPopupWindow();
        }
        this.mParent.getWindowVisibleDisplayFrame(this.mScreenViewPort);
        int suggestWidth = this.mSuggestedWidth > 0 ? this.mSuggestedWidth : this.mParent.getResources().getDimensionPixelSize(17105302);
        int sequenceNumber = this.mNextSequenceNumber++;
        ShowInfo showInfo = new ShowInfo();
        showInfo.sequenceNumber = sequenceNumber;
        showInfo.widgetToken = this.mFloatingToolbarToken;
        showInfo.layoutRequired = isLayoutRequired;
        showInfo.menuItems = RemoteFloatingToolbarPopup.getToolbarMenuItems(menuItems);
        showInfo.contentRect = contentRect;
        showInfo.suggestedWidth = suggestWidth;
        showInfo.viewPortOnScreen = this.mScreenViewPort;
        showInfo.hostInputToken = viewRootImpl.getInputToken();
        showInfo.isLightTheme = this.mIsLightTheme;
        showInfo.configuration = this.mContext.getResources().getConfiguration();
        if (DEBUG) {
            Log.v("floating_toolbar", "RemoteFloatingToolbarPopup.show() for " + showInfo);
        }
        this.mPendingMenuItemClickListeners.put(sequenceNumber, menuItemClickListener);
        this.mPendingMenuItems.put(sequenceNumber, menuItems);
        this.mPendingShowInfos.put(sequenceNumber, showInfo);
        this.mSelectionToolbarManager.showToolbar(showInfo, this.mSelectionToolbarCallback);
    }

    private boolean isLatestPendingOrCurrent(List<MenuItem> menuItems, MenuItem.OnMenuItemClickListener menuItemClickListener, Rect contentRect) {
        if (this.mPendingMenuItems.size() == 0) {
            return Objects.equals(menuItems, this.mMenuItems) && menuItemClickListener == this.mMenuItemClickListener && Objects.equals(contentRect, this.mContentRect);
        }
        int lastPendingIndex = this.mPendingMenuItems.size() - 1;
        return menuItemClickListener == this.mPendingMenuItemClickListeners.valueAt(lastPendingIndex) && Objects.equals(menuItems, this.mPendingMenuItems.valueAt(lastPendingIndex)) && Objects.equals(contentRect, this.mPendingShowInfos.valueAt((int)lastPendingIndex).contentRect);
    }

    @Override
    public void dismiss() {
        if (this.mState == 3) {
            Log.w("floating_toolbar", "The floating toolbar already dismissed.");
            return;
        }
        if (DEBUG) {
            Log.v("floating_toolbar", "RemoteFloatingToolbarPopup.dismiss().");
        }
        this.mSelectionToolbarManager.dismissToolbar(this.mFloatingToolbarToken);
        this.doDismissPopupWindow();
    }

    @Override
    public void hide() {
        if (this.mState == 3 || this.mState == 2) {
            if (DEBUG) {
                Log.v("floating_toolbar", "The floating toolbar already dismissed or hidden.");
            }
            return;
        }
        if (DEBUG) {
            Log.v("floating_toolbar", "RemoteFloatingToolbarPopup.hide().");
        }
        this.mSelectionToolbarManager.hideToolbar(this.mFloatingToolbarToken);
        this.mState = 2;
        this.mPopupWindow.dismiss();
    }

    @Override
    public void setSuggestedWidth(int suggestedWidth) {
        int difference = Math.abs(suggestedWidth - this.mSuggestedWidth);
        this.mWidthChanged = (double)difference > (double)this.mSuggestedWidth * 0.2;
        this.mSuggestedWidth = suggestedWidth;
    }

    @Override
    public void setWidthChanged(boolean widthChanged) {
        this.mWidthChanged = widthChanged;
    }

    @Override
    public boolean isHidden() {
        return this.mState == 2;
    }

    @Override
    public boolean isShowing() {
        return this.mState == 1;
    }

    @Override
    public boolean setOutsideTouchable(boolean outsideTouchable, @Nullable PopupWindow.OnDismissListener onDismiss) {
        if (this.mState == 3) {
            return false;
        }
        boolean ret = false;
        if (this.mPopupWindow.isOutsideTouchable() ^ outsideTouchable) {
            this.mPopupWindow.setOutsideTouchable(outsideTouchable);
            this.mPopupWindow.setFocusable(!outsideTouchable);
            this.mPopupWindow.update();
            ret = true;
        }
        this.mPopupWindow.setOnDismissListener(onDismiss);
        return ret;
    }

    private void updatePopupWindowContent(WidgetInfo widgetInfo) {
        if (DEBUG) {
            Log.v("floating_toolbar", "updatePopupWindowContent.");
        }
        ViewGroup contentContainer = (ViewGroup)this.mPopupWindow.getContentView();
        contentContainer.removeAllViews();
        SurfaceView surfaceView = new SurfaceView(this.mParent.getContext());
        surfaceView.setZOrderOnTop(true);
        surfaceView.getHolder().setFormat(-2);
        surfaceView.setChildSurfacePackage(widgetInfo.surfacePackage);
        contentContainer.addView(surfaceView);
    }

    private Point getCoordinatesInWindow(int x, int y) {
        this.mParent.getRootView().getLocationOnScreen(this.mCoordsOnScreen);
        this.mParent.getRootView().getLocationInWindow(this.mCoordsOnWindow);
        int windowLeftOnScreen = this.mCoordsOnScreen[0] - this.mCoordsOnWindow[0];
        int windowTopOnScreen = this.mCoordsOnScreen[1] - this.mCoordsOnWindow[1];
        return new Point(Math.max(0, x - windowLeftOnScreen), Math.max(0, y - windowTopOnScreen));
    }

    private static List<ToolbarMenuItem> getToolbarMenuItems(List<MenuItem> menuItems) {
        ArrayList<ToolbarMenuItem> list = new ArrayList<ToolbarMenuItem>(menuItems.size());
        int i = 0;
        while (i < menuItems.size()) {
            MenuItem menuItem = menuItems.get(i);
            ToolbarMenuItem toolbarMenuItem = new ToolbarMenuItem();
            toolbarMenuItem.itemId = menuItem.getItemId();
            toolbarMenuItem.itemIndex = i++;
            toolbarMenuItem.title = menuItem.getTitle();
            toolbarMenuItem.contentDescription = menuItem.getContentDescription();
            toolbarMenuItem.groupId = menuItem.getGroupId();
            toolbarMenuItem.icon = RemoteFloatingToolbarPopup.convertDrawableToIcon(menuItem.getIcon());
            toolbarMenuItem.tooltipText = menuItem.getTooltipText();
            toolbarMenuItem.priority = RemoteFloatingToolbarPopup.getPriorityFromMenuItem(menuItem);
            list.add(toolbarMenuItem);
        }
        return list;
    }

    private static Icon convertDrawableToIcon(Drawable drawable2) {
        BitmapDrawable bitmapDrawable;
        if (drawable2 == null) {
            return null;
        }
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
            return Icon.createWithBitmap(bitmapDrawable.getBitmap());
        }
        Bitmap bitmap = Bitmap.createBitmap(drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return Icon.createWithBitmap(bitmap);
    }

    private static int getPriorityFromMenuItem(MenuItem menuItem) {
        if (menuItem.requiresActionButton()) {
            return 1;
        }
        if (menuItem.requiresOverflow()) {
            return 2;
        }
        return 0;
    }

    private static PopupWindow createPopupWindow(Context content) {
        LinearLayout popupContentHolder = new LinearLayout(content);
        PopupWindow popupWindow = new PopupWindow(popupContentHolder);
        popupWindow.setClippingEnabled(false);
        popupWindow.setWindowLayoutType(1005);
        popupWindow.setAnimationStyle(0);
        popupWindow.setBackgroundDrawable(new ColorDrawable(0));
        return popupWindow;
    }

    private void doDismissPopupWindow() {
        if (DEBUG) {
            Log.v("floating_toolbar", "RemoteFloatingToolbarPopup.doDismiss().");
        }
        this.mState = 3;
        this.mMenuItems = null;
        this.mMenuItemClickListener = null;
        this.mFloatingToolbarToken = 0L;
        this.mSuggestedWidth = 0;
        this.mWidthChanged = true;
        this.resetCoords();
        this.mContentRect.setEmpty();
        this.mScreenViewPort.setEmpty();
        this.mPopupWindow.dismiss();
    }

    private void resetCoords() {
        this.mCoordsOnScreen[0] = 0;
        this.mCoordsOnScreen[1] = 0;
        this.mCoordsOnWindow[0] = 0;
        this.mCoordsOnWindow[1] = 0;
    }

    private void runOnUiThread(Runnable runnable) {
        this.mParent.post(runnable);
    }

    private void onShow(WidgetInfo info) {
        this.runOnUiThread(() -> {
            int sequenceNumber = info.sequenceNumber;
            this.mMenuItemClickListener = Objects.requireNonNull(this.mPendingMenuItemClickListeners.removeReturnOld(sequenceNumber));
            this.mMenuItems = Objects.requireNonNull(this.mPendingMenuItems.removeReturnOld(sequenceNumber));
            ShowInfo showInfo = Objects.requireNonNull(this.mPendingShowInfos.removeReturnOld(sequenceNumber));
            this.mContentRect.set(showInfo.contentRect);
            this.mFloatingToolbarToken = info.widgetToken;
            this.mState = 1;
            this.updatePopupWindowContent(info);
            Rect contentRect = info.contentRect;
            this.mPopupWindow.setWidth(contentRect.width());
            this.mPopupWindow.setHeight(contentRect.height());
            Point coords = this.getCoordinatesInWindow(contentRect.left, contentRect.top);
            this.mPopupWindow.showAtLocation(this.mParent, 0, coords.x, coords.y);
        });
    }

    private void onWidgetUpdated(WidgetInfo info) {
        this.runOnUiThread(() -> {
            if (!this.isShowing()) {
                Log.w("floating_toolbar", "onWidgetUpdated(): The widget isn't showing.");
                return;
            }
            this.updatePopupWindowContent(info);
            Rect contentRect = info.contentRect;
            Point coords = this.getCoordinatesInWindow(contentRect.left, contentRect.top);
            if (DEBUG) {
                Log.v("floating_toolbar", "PopupWindow x= " + coords.x + " y= " + coords.y + " w=" + contentRect.width() + " h=" + contentRect.height());
            }
            this.mPopupWindow.update(coords.x, coords.y, contentRect.width(), contentRect.height());
        });
    }

    private void onToolbarShowTimeout() {
        this.runOnUiThread(() -> {
            if (this.mState == 3) {
                return;
            }
            this.doDismissPopupWindow();
        });
    }

    private void onMenuItemClicked(int itemIndex) {
        this.runOnUiThread(() -> {
            if (this.mMenuItems == null || this.mMenuItemClickListener == null) {
                return;
            }
            MenuItem item = this.mMenuItems.get(itemIndex);
            if (DEBUG) {
                Log.v("floating_toolbar", "SelectionToolbarCallbackImpl onMenuItemClicked. itemIndex=" + itemIndex + " item=" + item);
            }
            if (item != null) {
                this.mMenuItemClickListener.onMenuItemClick(item);
            } else {
                Log.e("floating_toolbar", "onMenuItemClicked: cannot find menu item.");
            }
        });
    }

    private void onError(int errorCode, int sequenceNumber) {
        this.runOnUiThread(() -> {
            switch (errorCode) {
                case 1: {
                    Log.e("floating_toolbar", "onError: attempt to show multiple toolbars");
                    break;
                }
                case 2: {
                    Log.e("floating_toolbar", "onError: unknown widget token");
                }
            }
            this.mPendingMenuItemClickListeners.remove(sequenceNumber);
            this.mPendingMenuItems.remove(sequenceNumber);
            this.mPendingShowInfos.remove(sequenceNumber);
        });
    }

    private static class SelectionToolbarCallbackImpl
    extends ISelectionToolbarCallback.Stub {
        private final WeakReference<RemoteFloatingToolbarPopup> mRemotePopup;

        SelectionToolbarCallbackImpl(RemoteFloatingToolbarPopup popup) {
            this.mRemotePopup = new WeakReference<RemoteFloatingToolbarPopup>(popup);
        }

        @Override
        public void onShown(WidgetInfo info) {
            RemoteFloatingToolbarPopup remoteFloatingToolbarPopup;
            if (DEBUG) {
                Log.v("floating_toolbar", "SelectionToolbarCallbackImpl onShown: " + info);
            }
            if ((remoteFloatingToolbarPopup = (RemoteFloatingToolbarPopup)this.mRemotePopup.get()) != null) {
                remoteFloatingToolbarPopup.onShow(info);
            } else {
                Log.w("floating_toolbar", "Lost remoteFloatingToolbarPopup reference for onShown.");
            }
        }

        @Override
        public void onWidgetUpdated(WidgetInfo info) {
            RemoteFloatingToolbarPopup remoteFloatingToolbarPopup;
            if (DEBUG) {
                Log.v("floating_toolbar", "SelectionToolbarCallbackImpl onWidgetUpdated: info = " + info);
            }
            if ((remoteFloatingToolbarPopup = (RemoteFloatingToolbarPopup)this.mRemotePopup.get()) != null) {
                remoteFloatingToolbarPopup.onWidgetUpdated(info);
            } else {
                Log.w("floating_toolbar", "Lost remoteFloatingToolbarPopup reference for onWidgetUpdated.");
            }
        }

        @Override
        public void onToolbarShowTimeout() {
            RemoteFloatingToolbarPopup remoteFloatingToolbarPopup = (RemoteFloatingToolbarPopup)this.mRemotePopup.get();
            if (remoteFloatingToolbarPopup != null) {
                remoteFloatingToolbarPopup.onToolbarShowTimeout();
            } else {
                Log.w("floating_toolbar", "Lost remoteFloatingToolbarPopup reference for onToolbarShowTimeout.");
            }
        }

        @Override
        public void onMenuItemClicked(int itemIndex) {
            RemoteFloatingToolbarPopup remoteFloatingToolbarPopup = (RemoteFloatingToolbarPopup)this.mRemotePopup.get();
            if (remoteFloatingToolbarPopup != null) {
                remoteFloatingToolbarPopup.onMenuItemClicked(itemIndex);
            } else {
                Log.w("floating_toolbar", "Lost remoteFloatingToolbarPopup reference for onMenuItemClicked.");
            }
        }

        @Override
        public void onError(int errorCode, int sequenceNumber) {
            RemoteFloatingToolbarPopup remoteFloatingToolbarPopup = (RemoteFloatingToolbarPopup)this.mRemotePopup.get();
            if (remoteFloatingToolbarPopup != null) {
                remoteFloatingToolbarPopup.onError(errorCode, sequenceNumber);
            } else {
                Log.w("floating_toolbar", "Lost remoteFloatingToolbarPopup reference for onError.");
            }
        }
    }

    static class MenuItemRepr {
        public final int mItemId;
        public final int mGroupId;
        @Nullable
        public final String mTitle;
        @Nullable
        private final Drawable mIcon;

        private MenuItemRepr(int itemId, int groupId, @Nullable CharSequence title, @Nullable Drawable icon) {
            this.mItemId = itemId;
            this.mGroupId = groupId;
            this.mTitle = title == null ? null : title.toString();
            this.mIcon = icon;
        }

        public static MenuItemRepr of(MenuItem menuItem) {
            return new MenuItemRepr(menuItem.getItemId(), menuItem.getGroupId(), menuItem.getTitle(), menuItem.getIcon());
        }

        public int hashCode() {
            return Objects.hash(this.mItemId, this.mGroupId, this.mTitle, this.mIcon);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalFloatingToolbarPopup.MenuItemRepr)) {
                return false;
            }
            MenuItemRepr other = (MenuItemRepr)o;
            return this.mItemId == other.mItemId && this.mGroupId == other.mGroupId && TextUtils.equals(this.mTitle, other.mTitle) && Objects.equals(this.mIcon, other.mIcon);
        }

        public static boolean reprEquals(Collection<MenuItem> menuItems1, Collection<MenuItem> menuItems2) {
            if (menuItems1.size() != menuItems2.size()) {
                return false;
            }
            Iterator<MenuItem> menuItems2Iter = menuItems2.iterator();
            for (MenuItem menuItem1 : menuItems1) {
                MenuItem menuItem2 = menuItems2Iter.next();
                if (MenuItemRepr.of(menuItem1).equals(MenuItemRepr.of(menuItem2))) continue;
                return false;
            }
            return true;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ToolbarState {
    }
}

