/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.floatingtoolbar;

import android.annotation.Nullable;
import android.graphics.Rect;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.Window;
import android.widget.PopupWindow;
import com.android.internal.widget.floatingtoolbar.FloatingToolbarPopup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class FloatingToolbar {
    public static final String FLOATING_TOOLBAR_TAG = "floating_toolbar";
    private static final MenuItem.OnMenuItemClickListener NO_OP_MENUITEM_CLICK_LISTENER = item -> false;
    private final Window mWindow;
    private final FloatingToolbarPopup mPopup;
    private final Rect mContentRect = new Rect();
    private Menu mMenu;
    private MenuItem.OnMenuItemClickListener mMenuItemClickListener = NO_OP_MENUITEM_CLICK_LISTENER;
    private final View.OnLayoutChangeListener mOrientationChangeHandler = new View.OnLayoutChangeListener(){
        private final Rect mNewRect = new Rect();
        private final Rect mOldRect = new Rect();

        @Override
        public void onLayoutChange(View view, int newLeft, int newRight, int newTop, int newBottom, int oldLeft, int oldRight, int oldTop, int oldBottom) {
            this.mNewRect.set(newLeft, newRight, newTop, newBottom);
            this.mOldRect.set(oldLeft, oldRight, oldTop, oldBottom);
            if (FloatingToolbar.this.mPopup.isShowing() && !this.mNewRect.equals(this.mOldRect)) {
                FloatingToolbar.this.mPopup.setWidthChanged(true);
                FloatingToolbar.this.updateLayout();
            }
        }
    };
    private final Comparator<MenuItem> mMenuItemComparator = (menuItem1, menuItem2) -> {
        if (menuItem1.getItemId() == 16908353) {
            return menuItem2.getItemId() == 16908353 ? 0 : -1;
        }
        if (menuItem2.getItemId() == 16908353) {
            return 1;
        }
        if (menuItem1.requiresActionButton()) {
            return menuItem2.requiresActionButton() ? 0 : -1;
        }
        if (menuItem2.requiresActionButton()) {
            return 1;
        }
        if (menuItem1.requiresOverflow()) {
            return menuItem2.requiresOverflow() ? 0 : 1;
        }
        if (menuItem2.requiresOverflow()) {
            return -1;
        }
        return menuItem1.getOrder() - menuItem2.getOrder();
    };

    public FloatingToolbar(Window window) {
        this.mWindow = Objects.requireNonNull(window);
        this.mPopup = FloatingToolbarPopup.createInstance(window.getContext(), window.getDecorView());
    }

    public FloatingToolbar setMenu(Menu menu2) {
        this.mMenu = Objects.requireNonNull(menu2);
        return this;
    }

    public FloatingToolbar setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener menuItemClickListener) {
        this.mMenuItemClickListener = menuItemClickListener != null ? menuItemClickListener : NO_OP_MENUITEM_CLICK_LISTENER;
        return this;
    }

    public FloatingToolbar setContentRect(Rect rect) {
        this.mContentRect.set(Objects.requireNonNull(rect));
        return this;
    }

    public FloatingToolbar setSuggestedWidth(int suggestedWidth) {
        this.mPopup.setSuggestedWidth(suggestedWidth);
        return this;
    }

    public FloatingToolbar show() {
        this.registerOrientationHandler();
        this.doShow();
        return this;
    }

    public FloatingToolbar updateLayout() {
        if (this.mPopup.isShowing()) {
            this.doShow();
        }
        return this;
    }

    public void dismiss() {
        this.unregisterOrientationHandler();
        this.mPopup.dismiss();
    }

    public void hide() {
        this.mPopup.hide();
    }

    public boolean isShowing() {
        return this.mPopup.isShowing();
    }

    public boolean isHidden() {
        return this.mPopup.isHidden();
    }

    public void setOutsideTouchable(boolean outsideTouchable, @Nullable PopupWindow.OnDismissListener onDismiss) {
        this.mPopup.setOutsideTouchable(outsideTouchable, onDismiss);
    }

    private void doShow() {
        List<MenuItem> menuItems = FloatingToolbar.getVisibleAndEnabledMenuItems(this.mMenu);
        menuItems.sort(this.mMenuItemComparator);
        this.mPopup.show(menuItems, this.mMenuItemClickListener, this.mContentRect);
    }

    private static List<MenuItem> getVisibleAndEnabledMenuItems(Menu menu2) {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        for (int i = 0; menu2 != null && i < menu2.size(); ++i) {
            MenuItem menuItem = menu2.getItem(i);
            if (!menuItem.isVisible() || !menuItem.isEnabled()) continue;
            SubMenu subMenu = menuItem.getSubMenu();
            if (subMenu != null) {
                menuItems.addAll(FloatingToolbar.getVisibleAndEnabledMenuItems(subMenu));
                continue;
            }
            menuItems.add(menuItem);
        }
        return menuItems;
    }

    private void registerOrientationHandler() {
        this.unregisterOrientationHandler();
        this.mWindow.getDecorView().addOnLayoutChangeListener(this.mOrientationChangeHandler);
    }

    private void unregisterOrientationHandler() {
        this.mWindow.getDecorView().removeOnLayoutChangeListener(this.mOrientationChangeHandler);
    }
}

