/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.gatekeeper.GateKeeperResponse;
import android.util.Slog;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;

public class VerifyCredentialResponse
implements Parcelable {
    public static final int RESPONSE_OTHER_ERROR = -1;
    public static final int RESPONSE_OK = 0;
    public static final int RESPONSE_RETRY = 1;
    public static final int RESPONSE_CRED_TOO_SHORT = 2;
    public static final int RESPONSE_CRED_ALREADY_TRIED = 3;
    public static final int RESPONSE_CRED_INCORRECT = 4;
    public static final VerifyCredentialResponse OK = new Builder().build();
    public static final VerifyCredentialResponse OTHER_ERROR = VerifyCredentialResponse.fromError(-1);
    private static final String TAG = "VerifyCredentialResponse";
    private final int mResponseCode;
    private final int mTimeout;
    @Nullable
    private final byte[] mGatekeeperHAT;
    private final long mGatekeeperPasswordHandle;
    public static final Parcelable.Creator<VerifyCredentialResponse> CREATOR = new Parcelable.Creator<VerifyCredentialResponse>(){

        @Override
        public VerifyCredentialResponse createFromParcel(Parcel source) {
            int responseCode = source.readInt();
            int timeout = source.readInt();
            byte[] gatekeeperHAT = source.createByteArray();
            long gatekeeperPasswordHandle = source.readLong();
            return new VerifyCredentialResponse(responseCode, timeout, gatekeeperHAT, gatekeeperPasswordHandle);
        }

        public VerifyCredentialResponse[] newArray(int size) {
            return new VerifyCredentialResponse[size];
        }
    };

    public static VerifyCredentialResponse fromTimeout(int timeout) {
        return new VerifyCredentialResponse(1, timeout, null, 0L);
    }

    public static VerifyCredentialResponse fromTimeout(Duration timeout) {
        return VerifyCredentialResponse.fromTimeout((int)Math.min(timeout.toMillis(), Integer.MAX_VALUE));
    }

    public static VerifyCredentialResponse fromError() {
        return VerifyCredentialResponse.fromError(-1);
    }

    public static VerifyCredentialResponse fromError(int responseCode) {
        Preconditions.checkArgument(responseCode == -1 || responseCode == 2 || responseCode == 3 || responseCode == 4);
        return new VerifyCredentialResponse(responseCode, 0, null, 0L);
    }

    private VerifyCredentialResponse(int responseCode, int timeout, @Nullable byte[] gatekeeperHAT, long gatekeeperPasswordHandle) {
        this.mResponseCode = responseCode;
        this.mTimeout = timeout;
        this.mGatekeeperHAT = gatekeeperHAT;
        this.mGatekeeperPasswordHandle = gatekeeperPasswordHandle;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mResponseCode);
        dest.writeInt(this.mTimeout);
        dest.writeByteArray(this.mGatekeeperHAT);
        dest.writeLong(this.mGatekeeperPasswordHandle);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Nullable
    public byte[] getGatekeeperHAT() {
        return this.mGatekeeperHAT;
    }

    public long getGatekeeperPasswordHandle() {
        return this.mGatekeeperPasswordHandle;
    }

    public boolean containsGatekeeperPasswordHandle() {
        return this.mGatekeeperPasswordHandle != 0L;
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public Duration getTimeoutAsDuration() {
        return Duration.ofMillis(this.mTimeout);
    }

    public int getResponseCode() {
        return this.mResponseCode;
    }

    public boolean isMatched() {
        return this.mResponseCode == 0;
    }

    public String toString() {
        return "Response: " + this.mResponseCode + ", GK HAT: " + (this.mGatekeeperHAT != null) + ", GK PW: " + (this.mGatekeeperPasswordHandle != 0L);
    }

    public static VerifyCredentialResponse fromGateKeeperResponse(GateKeeperResponse gateKeeperResponse) {
        int responseCode = gateKeeperResponse.getResponseCode();
        if (responseCode == 1) {
            return VerifyCredentialResponse.fromTimeout(gateKeeperResponse.getTimeout());
        }
        if (responseCode == 0) {
            byte[] token = gateKeeperResponse.getPayload();
            if (token == null) {
                Slog.e(TAG, "verifyChallenge response had no associated payload");
                return VerifyCredentialResponse.fromError();
            }
            return new Builder().setGatekeeperHAT(token).build();
        }
        return VerifyCredentialResponse.fromError();
    }

    public static class Builder {
        @Nullable
        private byte[] mGatekeeperHAT;
        private long mGatekeeperPasswordHandle;

        public Builder setGatekeeperHAT(byte[] gatekeeperHAT) {
            this.mGatekeeperHAT = gatekeeperHAT;
            return this;
        }

        public Builder setGatekeeperPasswordHandle(long gatekeeperPasswordHandle) {
            this.mGatekeeperPasswordHandle = gatekeeperPasswordHandle;
            return this;
        }

        public VerifyCredentialResponse build() {
            return new VerifyCredentialResponse(0, 0, this.mGatekeeperHAT, this.mGatekeeperPasswordHandle);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ResponseCode {
    }
}

