/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.Nullable;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.RemoteViews;

@RemoteViews.RemoteView
public class NotificationMaxHeightFrameLayout
extends FrameLayout {
    private final int mNotificationMaxHeight;

    public NotificationMaxHeightFrameLayout(Context context) {
        this(context, null, 0, 0);
    }

    public NotificationMaxHeightFrameLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 0);
    }

    public NotificationMaxHeightFrameLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public NotificationMaxHeightFrameLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mNotificationMaxHeight = NotificationMaxHeightFrameLayout.getFontScaledHeight(this.mContext, 17105615);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getSize(heightMeasureSpec) > this.mNotificationMaxHeight) {
            int mode = View.MeasureSpec.getMode(heightMeasureSpec);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.mNotificationMaxHeight, mode);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private static int getFontScaledHeight(Context context, int dimenId) {
        int dimensionPixelSize = context.getResources().getDimensionPixelSize(dimenId);
        float factor = Math.max(1.0f, context.getResources().getDisplayMetrics().scaledDensity / context.getResources().getDisplayMetrics().density);
        return (int)((float)dimensionPixelSize * factor);
    }
}

