/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import com.android.internal.view.menu.ActionMenuItem;
import java.util.ArrayList;
import java.util.List;

public class ActionMenu
implements Menu {
    private Context mContext;
    private boolean mIsQwerty;
    private ArrayList<ActionMenuItem> mItems;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public ActionMenu(Context context) {
        this.mContext = context;
        this.mItems = new ArrayList();
    }

    public Context getContext() {
        return this.mContext;
    }

    @Override
    public MenuItem add(CharSequence title) {
        return this.add(0, 0, 0, title);
    }

    @Override
    public MenuItem add(int titleRes) {
        return this.add(0, 0, 0, titleRes);
    }

    @Override
    public MenuItem add(int groupId, int itemId, int order, int titleRes) {
        return this.add(groupId, itemId, order, this.mContext.getResources().getString(titleRes));
    }

    @Override
    public MenuItem add(int groupId, int itemId, int order, CharSequence title) {
        ActionMenuItem item = new ActionMenuItem(this.getContext(), groupId, itemId, 0, order, title);
        this.mItems.add(order, item);
        return item;
    }

    @Override
    public int addIntentOptions(int groupId, int itemId, int order, ComponentName caller, Intent[] specifics, Intent intent, int flags, MenuItem[] outSpecificItems) {
        int N2;
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> lri = pm.queryIntentActivityOptions(caller, specifics, intent, 0);
        int n = N2 = lri != null ? lri.size() : 0;
        if ((flags & 1) == 0) {
            this.removeGroup(groupId);
        }
        for (int i = 0; i < N2; ++i) {
            ResolveInfo ri = lri.get(i);
            Intent rintent = new Intent(ri.specificIndex < 0 ? intent : specifics[ri.specificIndex]);
            rintent.setComponent(new ComponentName(ri.activityInfo.applicationInfo.packageName, ri.activityInfo.name));
            MenuItem item = this.add(groupId, itemId, order, ri.loadLabel(pm)).setIcon(ri.loadIcon(pm)).setIntent(rintent);
            if (outSpecificItems == null || ri.specificIndex < 0) continue;
            outSpecificItems[ri.specificIndex] = item;
        }
        return N2;
    }

    @Override
    public SubMenu addSubMenu(CharSequence title) {
        return null;
    }

    @Override
    public SubMenu addSubMenu(int titleRes) {
        return null;
    }

    @Override
    public SubMenu addSubMenu(int groupId, int itemId, int order, CharSequence title) {
        return null;
    }

    @Override
    public SubMenu addSubMenu(int groupId, int itemId, int order, int titleRes) {
        return null;
    }

    @Override
    public void clear() {
        this.mItems.clear();
    }

    @Override
    public void close() {
    }

    private int findItemIndex(int id2) {
        ArrayList<ActionMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            if (items.get(i).getItemId() != id2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public MenuItem findItem(int id2) {
        return this.mItems.get(this.findItemIndex(id2));
    }

    @Override
    public MenuItem getItem(int index) {
        return this.mItems.get(index);
    }

    @Override
    public boolean hasVisibleItems() {
        ArrayList<ActionMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            if (!items.get(i).isVisible()) continue;
            return true;
        }
        return false;
    }

    private ActionMenuItem findItemWithShortcut(int keyCode, KeyEvent event) {
        boolean qwerty = this.mIsQwerty;
        ArrayList<ActionMenuItem> items = this.mItems;
        int itemCount = items.size();
        int modifierState = event.getModifiers();
        for (int i = 0; i < itemCount; ++i) {
            boolean is_modifiers_exact_match;
            ActionMenuItem item = items.get(i);
            char shortcut = qwerty ? item.getAlphabeticShortcut() : item.getNumericShortcut();
            int shortcutModifiers = qwerty ? item.getAlphabeticModifiers() : item.getNumericModifiers();
            boolean bl = is_modifiers_exact_match = (modifierState & 0x1100F) == (shortcutModifiers & 0x1100F);
            if (keyCode != shortcut || !is_modifiers_exact_match) continue;
            return item;
        }
        return null;
    }

    @Override
    public boolean isShortcutKey(int keyCode, KeyEvent event) {
        return this.findItemWithShortcut(keyCode, event) != null;
    }

    @Override
    public boolean performIdentifierAction(int id2, int flags) {
        int index = this.findItemIndex(id2);
        if (index < 0) {
            return false;
        }
        return this.mItems.get(index).invoke();
    }

    @Override
    public boolean performShortcut(int keyCode, KeyEvent event, int flags) {
        ActionMenuItem item = this.findItemWithShortcut(keyCode, event);
        if (item == null) {
            return false;
        }
        return item.invoke();
    }

    @Override
    public void removeGroup(int groupId) {
        ArrayList<ActionMenuItem> items = this.mItems;
        int itemCount = items.size();
        int i = 0;
        while (i < itemCount) {
            if (items.get(i).getGroupId() == groupId) {
                items.remove(i);
                --itemCount;
                continue;
            }
            ++i;
        }
    }

    @Override
    public void removeItem(int id2) {
        this.mItems.remove(this.findItemIndex(id2));
    }

    @Override
    public void setGroupCheckable(int group, boolean checkable, boolean exclusive) {
        ArrayList<ActionMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            ActionMenuItem item = items.get(i);
            if (item.getGroupId() != group) continue;
            item.setCheckable(checkable);
            item.setExclusiveCheckable(exclusive);
        }
    }

    @Override
    public void setGroupEnabled(int group, boolean enabled) {
        ArrayList<ActionMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            ActionMenuItem item = items.get(i);
            if (item.getGroupId() != group) continue;
            item.setEnabled(enabled);
        }
    }

    @Override
    public void setGroupVisible(int group, boolean visible) {
        ArrayList<ActionMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            ActionMenuItem item = items.get(i);
            if (item.getGroupId() != group) continue;
            item.setVisible(visible);
        }
    }

    @Override
    public void setQwertyMode(boolean isQwerty) {
        this.mIsQwerty = isQwerty;
    }

    @Override
    public int size() {
        return this.mItems.size();
    }
}

