/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.annotation.NonNull;
import android.graphics.Rect;
import android.os.CancellationSignal;
import android.view.View;
import android.view.ViewGroup;
import java.util.function.Consumer;

public interface ScrollCaptureViewHelper<V extends View> {
    public static final int UP = -1;
    public static final int DOWN = 1;

    public boolean onAcceptSession(@NonNull V var1);

    @NonNull
    default public Rect onComputeScrollBounds(@NonNull V view) {
        Rect bounds = new Rect(0, 0, ((View)view).getWidth(), ((View)view).getHeight());
        if (view instanceof ViewGroup && ((ViewGroup)view).getClipToPadding()) {
            bounds.inset(((View)view).getPaddingLeft(), ((View)view).getPaddingTop(), ((View)view).getPaddingRight(), ((View)view).getPaddingBottom());
        }
        return bounds;
    }

    public void onPrepareForStart(@NonNull V var1, @NonNull Rect var2);

    @NonNull
    public void onScrollRequested(@NonNull V var1, @NonNull Rect var2, @NonNull Rect var3, CancellationSignal var4, Consumer<ScrollResult> var5);

    public void onPrepareForEnd(@NonNull V var1);

    public static class ScrollResult {
        public Rect requestedArea;
        public Rect availableArea;
        public int scrollDelta;

        public String toString() {
            return "ScrollResult{requestedArea=" + this.requestedArea + ", availableArea=" + this.availableArea + ", scrollDelta=" + this.scrollDelta + '}';
        }
    }
}

