/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.view.DragEvent;
import android.view.IScrollCaptureResponseListener;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.ScrollCaptureResponse;
import android.view.WindowRelayoutResult;
import android.view.inputmethod.ImeTracker;
import com.android.internal.os.IResultReceiver;
import java.io.IOException;

public class BaseIWindow
extends IWindow.Stub {
    private IWindowSession mSession;

    @UnsupportedAppUsage(maxTargetSdk=28)
    public BaseIWindow() {
    }

    public void setSession(IWindowSession session) {
        this.mSession = session;
    }

    @Override
    public void resized(WindowRelayoutResult layout2, boolean reportDraw, boolean forceLayout, int displayId, boolean syncWithBuffers, boolean dragResizing) {
        if (reportDraw) {
            try {
                this.mSession.finishDrawing(this, null, layout2.syncSeqId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void insetsControlChanged(InsetsState insetsState, InsetsSourceControl.Array activeControls) {
    }

    @Override
    public void showInsets(int types, @Nullable ImeTracker.Token statsToken) {
    }

    @Override
    public void hideInsets(int types, @Nullable ImeTracker.Token statsToken) {
    }

    @Override
    public void moved(int newX, int newY) {
    }

    @Override
    public void dispatchAppVisibility(boolean visible, int seqId) {
    }

    @Override
    public void dispatchGetNewSurface() {
    }

    @Override
    public void executeCommand(String command, String parameters, ParcelFileDescriptor out) {
        if (out != null) {
            try {
                out.closeWithError("Unsupported command " + command);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void closeSystemDialogs(String reason) {
    }

    @Override
    public void dispatchWallpaperOffsets(float x, float y, float xStep, float yStep, float zoom, boolean sync) {
        if (sync) {
            try {
                this.mSession.wallpaperOffsetsComplete(this.asBinder());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void dispatchDragEvent(DragEvent event) {
        if (event.getAction() == 3) {
            try {
                this.mSession.reportDropResult(this, false);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras, boolean sync) {
        if (sync) {
            try {
                this.mSession.wallpaperCommandComplete(this.asBinder(), null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void dispatchWindowShown() {
    }

    @Override
    public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) {
    }

    @Override
    public void requestScrollCapture(IScrollCaptureResponseListener listener) {
        try {
            listener.onScrollCaptureResponse(new ScrollCaptureResponse.Builder().setDescription("Not Implemented").build());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void dumpWindow(ParcelFileDescriptor pfd) {
    }
}

