/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.vibrator.persistence;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.VibrationEffect;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public class XmlConstants {
    public static final String NAMESPACE = null;
    public static final String TAG_VIBRATION_EFFECT = "vibration-effect";
    public static final String TAG_VIBRATION_SELECT = "vibration-select";
    public static final String TAG_PREDEFINED_EFFECT = "predefined-effect";
    public static final String TAG_PRIMITIVE_EFFECT = "primitive-effect";
    public static final String TAG_VENDOR_EFFECT = "vendor-effect";
    public static final String TAG_WAVEFORM_ENVELOPE_EFFECT = "waveform-envelope-effect";
    public static final String TAG_BASIC_ENVELOPE_EFFECT = "basic-envelope-effect";
    public static final String TAG_WAVEFORM_EFFECT = "waveform-effect";
    public static final String TAG_REPEATING_EFFECT = "repeating-effect";
    public static final String TAG_WAVEFORM_ENTRY = "waveform-entry";
    public static final String TAG_REPEATING = "repeating";
    public static final String TAG_PREAMBLE = "preamble";
    public static final String TAG_CONTROL_POINT = "control-point";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_FALLBACK = "fallback";
    public static final String ATTRIBUTE_DURATION_MS = "durationMs";
    public static final String ATTRIBUTE_AMPLITUDE = "amplitude";
    public static final String ATTRIBUTE_FREQUENCY_HZ = "frequencyHz";
    public static final String ATTRIBUTE_INITIAL_FREQUENCY_HZ = "initialFrequencyHz";
    public static final String ATTRIBUTE_INTENSITY = "intensity";
    public static final String ATTRIBUTE_SHARPNESS = "sharpness";
    public static final String ATTRIBUTE_INITIAL_SHARPNESS = "initialSharpness";
    public static final String ATTRIBUTE_SCALE = "scale";
    public static final String ATTRIBUTE_DELAY_MS = "delayMs";
    public static final String ATTRIBUTE_DELAY_TYPE = "delayType";
    public static final String VALUE_AMPLITUDE_DEFAULT = "default";
    public static final int FLAG_ALLOW_HIDDEN_APIS = 1;

    public static enum PrimitiveDelayType {
        PAUSE(0),
        RELATIVE_START_OFFSET(1);

        private final int mDelayType;

        private PrimitiveDelayType(int type) {
            this.mDelayType = type;
        }

        @Nullable
        public static PrimitiveDelayType findByType(int delayType) {
            for (PrimitiveDelayType type : PrimitiveDelayType.values()) {
                if (type.mDelayType != delayType) continue;
                return type;
            }
            return null;
        }

        @Nullable
        public static PrimitiveDelayType findByName(@NonNull String delayType) {
            try {
                return PrimitiveDelayType.valueOf(delayType.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public int getDelayType() {
            return this.mDelayType;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum PredefinedEffectName {
        TICK(2, true),
        CLICK(0, true),
        HEAVY_CLICK(5, true),
        DOUBLE_CLICK(1, true),
        TEXTURE_TICK(21, false),
        THUD(3, false),
        POP(4, false),
        RINGTONE_1(VibrationEffect.RINGTONES[0], false),
        RINGTONE_2(VibrationEffect.RINGTONES[1], false),
        RINGTONE_3(VibrationEffect.RINGTONES[2], false),
        RINGTONE_4(VibrationEffect.RINGTONES[3], false),
        RINGTONE_5(VibrationEffect.RINGTONES[4], false),
        RINGTONE_6(VibrationEffect.RINGTONES[5], false),
        RINGTONE_7(VibrationEffect.RINGTONES[6], false),
        RINGTONE_8(VibrationEffect.RINGTONES[7], false),
        RINGTONE_9(VibrationEffect.RINGTONES[8], false),
        RINGTONE_10(VibrationEffect.RINGTONES[9], false),
        RINGTONE_11(VibrationEffect.RINGTONES[10], false),
        RINGTONE_12(VibrationEffect.RINGTONES[11], false),
        RINGTONE_13(VibrationEffect.RINGTONES[12], false),
        RINGTONE_14(VibrationEffect.RINGTONES[13], false),
        RINGTONE_15(VibrationEffect.RINGTONES[14], false);

        private final int mEffectId;
        private final boolean mIsPublic;

        private PredefinedEffectName(int id2, boolean isPublic) {
            this.mEffectId = id2;
            this.mIsPublic = isPublic;
        }

        @Nullable
        public static PredefinedEffectName findById(int effectId, int flags) {
            boolean allowHidden = (flags & 1) != 0;
            for (PredefinedEffectName name : PredefinedEffectName.values()) {
                if (name.mEffectId != effectId) continue;
                return name.mIsPublic || allowHidden ? name : null;
            }
            return null;
        }

        @Nullable
        public static PredefinedEffectName findByName(@NonNull String effectName, int flags) {
            boolean allowHidden = (flags & 1) != 0;
            try {
                PredefinedEffectName name = PredefinedEffectName.valueOf(effectName.toUpperCase(Locale.ROOT));
                return name.mIsPublic || allowHidden ? name : null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public int getEffectId() {
            return this.mEffectId;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum PrimitiveEffectName {
        LOW_TICK(8),
        TICK(7),
        CLICK(1),
        SLOW_RISE(5),
        QUICK_RISE(4),
        QUICK_FALL(6),
        SPIN(3),
        THUD(2);

        private final int mPrimitiveId;

        private PrimitiveEffectName(int id2) {
            this.mPrimitiveId = id2;
        }

        @Nullable
        public static PrimitiveEffectName findById(int primitiveId) {
            for (PrimitiveEffectName name : PrimitiveEffectName.values()) {
                if (name.mPrimitiveId != primitiveId) continue;
                return name;
            }
            return null;
        }

        @Nullable
        public static PrimitiveEffectName findByName(@NonNull String primitiveName) {
            try {
                return PrimitiveEffectName.valueOf(primitiveName.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public int getPrimitiveId() {
            return this.mPrimitiveId;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

