/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.SystemClock;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@RavenwoodKeepWholeClass
public class RateLimitingCache<Value> {
    private final long mPeriodMillis;
    private final int mLimit;
    private final long mRandomOffset;
    private final AtomicReference<CachedValue> mCachedValue = new AtomicReference();

    public RateLimitingCache(long periodMillis) {
        this(periodMillis, 1);
    }

    public RateLimitingCache(long periodMillis, int count) {
        this.mPeriodMillis = periodMillis;
        this.mLimit = count;
        this.mRandomOffset = this.mLimit > 1 && periodMillis > 1L ? (long)(Math.random() * (double)(periodMillis / 2L)) : 0L;
    }

    protected long getTime() {
        return SystemClock.elapsedRealtime();
    }

    public Value get(ValueFetcher<Value> query) {
        boolean newWindow;
        CachedValue cached = this.mCachedValue.get();
        if (this.mPeriodMillis < 0L && cached != null && cached.timestamp != 0L) {
            return cached.value;
        }
        long now = this.getTime() + this.mRandomOffset;
        boolean bl = newWindow = cached == null || now - cached.timestamp >= this.mPeriodMillis;
        if (newWindow || cached.count.getAndIncrement() < this.mLimit) {
            Value freshValue = query.fetchValue();
            long freshTimestamp = now;
            if (this.mLimit > 1) {
                freshTimestamp = now - now % this.mPeriodMillis;
            }
            CachedValue freshCached = new CachedValue(this);
            freshCached.value = freshValue;
            freshCached.timestamp = freshTimestamp;
            freshCached.count = newWindow ? new AtomicInteger(1) : cached.count;
            this.mCachedValue.compareAndSet(cached, freshCached);
        }
        return this.mCachedValue.get().value;
    }

    class CachedValue {
        Value value;
        long timestamp;
        AtomicInteger count;

        CachedValue(RateLimitingCache this$0) {
        }
    }

    public static interface ValueFetcher<V> {
        public V fetchValue();
    }
}

