/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.util.Comparator;
import java.util.List;

@RavenwoodKeepWholeClass
public class QuickSelect {
    private static <T> int selectImpl(@NonNull List<T> list, int left, int right, int k, @NonNull Comparator<? super T> comparator) {
        while (left != right) {
            int pivotIndex = QuickSelect.partition(list, left, right, left + right >> 1, comparator);
            if (k == pivotIndex) {
                return k;
            }
            if (k < pivotIndex) {
                right = pivotIndex - 1;
                continue;
            }
            left = pivotIndex + 1;
        }
        return left;
    }

    private static int selectImpl(@NonNull int[] array2, int left, int right, int k) {
        while (left != right) {
            int pivotIndex = QuickSelect.partition(array2, left, right, left + right >> 1);
            if (k == pivotIndex) {
                return k;
            }
            if (k < pivotIndex) {
                right = pivotIndex - 1;
                continue;
            }
            left = pivotIndex + 1;
        }
        return left;
    }

    private static int selectImpl(@NonNull long[] array2, int left, int right, int k) {
        while (left != right) {
            int pivotIndex = QuickSelect.partition(array2, left, right, left + right >> 1);
            if (k == pivotIndex) {
                return k;
            }
            if (k < pivotIndex) {
                right = pivotIndex - 1;
                continue;
            }
            left = pivotIndex + 1;
        }
        return left;
    }

    private static <T> int selectImpl(@NonNull T[] array2, int left, int right, int k, @NonNull Comparator<? super T> comparator) {
        while (left != right) {
            int pivotIndex = QuickSelect.partition(array2, left, right, left + right >> 1, comparator);
            if (k == pivotIndex) {
                return k;
            }
            if (k < pivotIndex) {
                right = pivotIndex - 1;
                continue;
            }
            left = pivotIndex + 1;
        }
        return left;
    }

    private static <T> int partition(@NonNull List<T> list, int left, int right, int pivotIndex, @NonNull Comparator<? super T> comparator) {
        T pivotValue = list.get(pivotIndex);
        QuickSelect.swap(list, right, pivotIndex);
        int storeIndex = left;
        for (int i = left; i < right; ++i) {
            if (comparator.compare(list.get(i), pivotValue) >= 0) continue;
            QuickSelect.swap(list, storeIndex, i);
            ++storeIndex;
        }
        QuickSelect.swap(list, right, storeIndex);
        return storeIndex;
    }

    private static int partition(@NonNull int[] array2, int left, int right, int pivotIndex) {
        int pivotValue = array2[pivotIndex];
        QuickSelect.swap(array2, right, pivotIndex);
        int storeIndex = left;
        for (int i = left; i < right; ++i) {
            if (array2[i] >= pivotValue) continue;
            QuickSelect.swap(array2, storeIndex, i);
            ++storeIndex;
        }
        QuickSelect.swap(array2, right, storeIndex);
        return storeIndex;
    }

    private static int partition(@NonNull long[] array2, int left, int right, int pivotIndex) {
        long pivotValue = array2[pivotIndex];
        QuickSelect.swap(array2, right, pivotIndex);
        int storeIndex = left;
        for (int i = left; i < right; ++i) {
            if (array2[i] >= pivotValue) continue;
            QuickSelect.swap(array2, storeIndex, i);
            ++storeIndex;
        }
        QuickSelect.swap(array2, right, storeIndex);
        return storeIndex;
    }

    private static <T> int partition(@NonNull T[] array2, int left, int right, int pivotIndex, @NonNull Comparator<? super T> comparator) {
        T pivotValue = array2[pivotIndex];
        QuickSelect.swap(array2, right, pivotIndex);
        int storeIndex = left;
        for (int i = left; i < right; ++i) {
            if (comparator.compare(array2[i], pivotValue) >= 0) continue;
            QuickSelect.swap(array2, storeIndex, i);
            ++storeIndex;
        }
        QuickSelect.swap(array2, right, storeIndex);
        return storeIndex;
    }

    private static <T> void swap(@NonNull List<T> list, int left, int right) {
        T tmp = list.get(left);
        list.set(left, list.get(right));
        list.set(right, tmp);
    }

    private static void swap(@NonNull int[] array2, int left, int right) {
        int tmp = array2[left];
        array2[left] = array2[right];
        array2[right] = tmp;
    }

    private static void swap(@NonNull long[] array2, int left, int right) {
        long tmp = array2[left];
        array2[left] = array2[right];
        array2[right] = tmp;
    }

    private static <T> void swap(@NonNull T[] array2, int left, int right) {
        T tmp = array2[left];
        array2[left] = array2[right];
        array2[right] = tmp;
    }

    @Nullable
    public static <T> T select(@NonNull List<T> list, int start, int length, int k, @NonNull Comparator<? super T> comparator) {
        if (list == null || start < 0 || length <= 0 || list.size() < start + length || k < 0 || length <= k) {
            throw new IllegalArgumentException();
        }
        return list.get(QuickSelect.selectImpl(list, start, start + length - 1, k + start, comparator));
    }

    public static int select(@NonNull int[] array2, int start, int length, int k) {
        if (array2 == null || start < 0 || length <= 0 || array2.length < start + length || k < 0 || length <= k) {
            throw new IllegalArgumentException();
        }
        return array2[QuickSelect.selectImpl(array2, start, start + length - 1, k + start)];
    }

    public static long select(@NonNull long[] array2, int start, int length, int k) {
        if (array2 == null || start < 0 || length <= 0 || array2.length < start + length || k < 0 || length <= k) {
            throw new IllegalArgumentException();
        }
        return array2[QuickSelect.selectImpl(array2, start, start + length - 1, k + start)];
    }

    public static <T> T select(@NonNull T[] array2, int start, int length, int k, @NonNull Comparator<? super T> comparator) {
        if (array2 == null || start < 0 || length <= 0 || array2.length < start + length || k < 0 || length <= k) {
            throw new IllegalArgumentException();
        }
        return array2[QuickSelect.selectImpl(array2, start, start + length - 1, k + start, comparator)];
    }
}

