/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.nio.charset.StandardCharsets;

@RavenwoodKeepWholeClass
public class ProcFileReader
implements Closeable {
    private final InputStream mStream;
    private final byte[] mBuffer;
    private int mTail;
    private boolean mLineFinished;

    public ProcFileReader(InputStream stream) throws IOException {
        this(stream, 4096);
    }

    public ProcFileReader(InputStream stream, int bufferSize) throws IOException {
        this.mStream = stream;
        this.mBuffer = new byte[bufferSize];
        if (stream.markSupported()) {
            this.mStream.mark(0);
        }
        this.fillBuf();
    }

    private int fillBuf() throws IOException {
        int length = this.mBuffer.length - this.mTail;
        if (length == 0) {
            throw new IOException("attempting to fill already-full buffer");
        }
        int read = this.mStream.read(this.mBuffer, this.mTail, length);
        if (read != -1) {
            this.mTail += read;
        }
        return read;
    }

    private void consumeBuf(int count) throws IOException {
        while (count < this.mTail && this.mBuffer[count] == 32) {
            ++count;
        }
        System.arraycopy(this.mBuffer, count, this.mBuffer, 0, this.mTail - count);
        this.mTail -= count;
        if (this.mTail == 0) {
            this.fillBuf();
            if (this.mTail > 0 && this.mBuffer[0] == 32) {
                this.consumeBuf(0);
            }
        }
    }

    private int nextTokenIndex() throws IOException {
        if (this.mLineFinished) {
            return -1;
        }
        int i = 0;
        while (true) {
            if (i < this.mTail) {
                byte b = this.mBuffer[i];
                if (b == 10) {
                    this.mLineFinished = true;
                    return i;
                }
                if (b == 32) {
                    return i;
                }
                ++i;
                continue;
            }
            if (this.fillBuf() <= 0) break;
        }
        throw new ProtocolException("End of stream while looking for token boundary");
    }

    public boolean hasMoreData() {
        return this.mTail > 0;
    }

    public void finishLine() throws IOException {
        if (this.mLineFinished) {
            this.mLineFinished = false;
            return;
        }
        int i = 0;
        while (true) {
            if (i < this.mTail) {
                if (this.mBuffer[i] == 10) {
                    this.consumeBuf(i + 1);
                    return;
                }
                ++i;
                continue;
            }
            if (this.fillBuf() <= 0) break;
        }
        throw new ProtocolException("End of stream while looking for line boundary");
    }

    public String nextString() throws IOException {
        int tokenIndex = this.nextTokenIndex();
        if (tokenIndex == -1) {
            throw new ProtocolException("Missing required string");
        }
        return this.parseAndConsumeString(tokenIndex);
    }

    public long nextLong() throws IOException {
        return this.nextLong(false);
    }

    public long nextLong(boolean stopAtInvalid) throws IOException {
        int tokenIndex = this.nextTokenIndex();
        if (tokenIndex == -1) {
            throw new ProtocolException("Missing required long");
        }
        return this.parseAndConsumeLong(tokenIndex, stopAtInvalid);
    }

    public long nextOptionalLong(long def) throws IOException {
        int tokenIndex = this.nextTokenIndex();
        if (tokenIndex == -1) {
            return def;
        }
        return this.parseAndConsumeLong(tokenIndex, false);
    }

    private String parseAndConsumeString(int tokenIndex) throws IOException {
        String s = new String(this.mBuffer, 0, tokenIndex, StandardCharsets.US_ASCII);
        this.consumeBuf(tokenIndex + 1);
        return s;
    }

    private long parseAndConsumeLong(int tokenIndex, boolean stopAtInvalid) throws IOException {
        int i;
        boolean negative = this.mBuffer[0] == 45;
        long result = 0L;
        int n = i = negative ? 1 : 0;
        while (i < tokenIndex) {
            int digit = this.mBuffer[i] - 48;
            if (digit < 0 || digit > 9) {
                if (stopAtInvalid) break;
                throw this.invalidLong(tokenIndex);
            }
            long next = result * 10L - (long)digit;
            if (next > result) {
                throw this.invalidLong(tokenIndex);
            }
            result = next;
            ++i;
        }
        this.consumeBuf(tokenIndex + 1);
        return negative ? result : -result;
    }

    private NumberFormatException invalidLong(int tokenIndex) {
        return new NumberFormatException("invalid long: " + new String(this.mBuffer, 0, tokenIndex, StandardCharsets.US_ASCII));
    }

    public int nextInt() throws IOException {
        long value = this.nextLong();
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new NumberFormatException("parsed value larger than integer");
        }
        return (int)value;
    }

    public void nextIgnored() throws IOException {
        int tokenIndex = this.nextTokenIndex();
        if (tokenIndex == -1) {
            throw new ProtocolException("Missing required token");
        }
        this.consumeBuf(tokenIndex + 1);
    }

    public void rewind() throws IOException {
        if (this.mStream instanceof FileInputStream) {
            ((FileInputStream)this.mStream).getChannel().position(0L);
        } else if (this.mStream.markSupported()) {
            this.mStream.reset();
        } else {
            throw new IOException("The InputStream is NOT markable");
        }
        this.mTail = 0;
        this.mLineFinished = false;
        this.fillBuf();
    }

    @Override
    public void close() throws IOException {
        this.mStream.close();
    }
}

