/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.NonNull;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.CallbackRegistry;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

public class ObservableServiceConnection<T>
implements ServiceConnection {
    public static final int DISCONNECT_REASON_NONE = 0;
    public static final int DISCONNECT_REASON_NULL_BINDING = 1;
    public static final int DISCONNECT_REASON_DISCONNECTED = 2;
    public static final int DISCONNECT_REASON_BINDING_DIED = 3;
    public static final int DISCONNECT_REASON_UNBIND = 4;
    private final Object mLock = new Object();
    private final Context mContext;
    private final Executor mExecutor;
    private final ServiceTransformer<T> mTransformer;
    private final Intent mServiceIntent;
    private final int mFlags;
    @GuardedBy(value={"mLock"})
    private T mService;
    @GuardedBy(value={"mLock"})
    private boolean mBoundCalled = false;
    @GuardedBy(value={"mLock"})
    private int mLastDisconnectReason = 0;
    private final CallbackRegistry<Callback<T>, ObservableServiceConnection<T>, T> mCallbackRegistry = new CallbackRegistry(new CallbackRegistry.NotifierCallback<Callback<T>, ObservableServiceConnection<T>, T>(){

        @Override
        public void onNotifyCallback(Callback<T> callback, ObservableServiceConnection<T> sender, int disconnectReason, T service) {
            ObservableServiceConnection.this.mExecutor.execute(() -> {
                Object object = ObservableServiceConnection.this.mLock;
                synchronized (object) {
                    if (service != null) {
                        callback.onConnected(sender, service);
                    } else if (ObservableServiceConnection.this.mLastDisconnectReason != 0) {
                        callback.onDisconnected(sender, disconnectReason);
                    }
                }
            });
        }
    });

    public ObservableServiceConnection(@NonNull Context context, @NonNull Executor executor, @NonNull ServiceTransformer<T> transformer, Intent serviceIntent, int flags) {
        this.mContext = context;
        this.mExecutor = executor;
        this.mTransformer = transformer;
        this.mServiceIntent = serviceIntent;
        this.mFlags = flags;
    }

    public void execute(Runnable runnable) {
        this.mExecutor.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBoundCalled) {
                return false;
            }
            boolean bindResult = this.mContext.bindService(this.mServiceIntent, this.mFlags, this.mExecutor, (ServiceConnection)this);
            this.mBoundCalled = true;
            return bindResult;
        }
    }

    public void unbind() {
        this.onDisconnected(4);
    }

    public void addCallback(Callback<T> callback) {
        this.mCallbackRegistry.add(callback);
        this.mExecutor.execute(() -> {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mService != null) {
                    callback.onConnected(this, this.mService);
                } else if (this.mLastDisconnectReason != 0) {
                    callback.onDisconnected(this, this.mLastDisconnectReason);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(Callback<T> callback) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackRegistry.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDisconnected(int reason) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mBoundCalled) {
                return;
            }
            this.mBoundCalled = false;
            this.mLastDisconnectReason = reason;
            this.mContext.unbindService(this);
            this.mService = null;
            this.mCallbackRegistry.notifyCallbacks(this, reason, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        Object object = this.mLock;
        synchronized (object) {
            this.mService = this.mTransformer.convert(service);
            this.mLastDisconnectReason = 0;
            this.mCallbackRegistry.notifyCallbacks(this, this.mLastDisconnectReason, (ObservableServiceConnection)this.mService);
        }
    }

    @Override
    public void onServiceDisconnected(ComponentName name) {
        this.onDisconnected(2);
    }

    @Override
    public void onBindingDied(ComponentName name) {
        this.onDisconnected(3);
    }

    @Override
    public void onNullBinding(ComponentName name) {
        this.onDisconnected(1);
    }

    public static interface ServiceTransformer<T> {
        public T convert(IBinder var1);
    }

    public static interface Callback<T> {
        public void onConnected(ObservableServiceConnection<T> var1, T var2);

        public void onDisconnected(ObservableServiceConnection<T> var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisconnectReason {
    }
}

