/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.Log;
import android.util.SparseArray;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

@RavenwoodKeepWholeClass
public class MessageUtils {
    private static final String TAG = MessageUtils.class.getSimpleName();
    private static final boolean DBG = false;
    public static final String[] DEFAULT_PREFIXES = new String[]{"CMD_", "EVENT_"};

    public static SparseArray<String> findMessageNames(Class[] classes, String[] prefixes) {
        SparseArray<String> messageNames = new SparseArray<String>();
        for (Class c : classes) {
            Field[] fields;
            String className = c.getName();
            try {
                fields = c.getDeclaredFields();
            }
            catch (SecurityException e) {
                Log.e(TAG, "Can't list fields of class " + className);
                continue;
            }
            block7: for (Field field : fields) {
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) | !Modifier.isFinal(modifiers)) continue;
                String name = field.getName();
                for (String prefix : prefixes) {
                    if (!name.startsWith(prefix)) continue;
                    try {
                        int value;
                        field.setAccessible(true);
                        try {
                            value = field.getInt(null);
                        }
                        catch (ExceptionInInitializerError | IllegalArgumentException e) {
                            continue block7;
                        }
                        String previousName = messageNames.get(value);
                        if (previousName != null && !previousName.equals(name)) {
                            throw new DuplicateConstantError(name, previousName, value);
                        }
                        messageNames.put(value, name);
                    }
                    catch (IllegalAccessException | SecurityException e) {
                        // empty catch block
                    }
                }
            }
        }
        return messageNames;
    }

    public static SparseArray<String> findMessageNames(Class[] classNames) {
        return MessageUtils.findMessageNames(classNames, DEFAULT_PREFIXES);
    }

    public static class DuplicateConstantError
    extends Error {
        private DuplicateConstantError() {
        }

        public DuplicateConstantError(String name1, String name2, int value) {
            super(String.format("Duplicate constant value: both %s and %s = %d", name1, name2, value));
        }
    }
}

