/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.SipDialogState;
import java.util.ArrayList;
import java.util.List;

public interface ISipDialogStateCallback
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.telephony.ISipDialogStateCallback";

    public void onActiveSipDialogsChanged(List<SipDialogState> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISipDialogStateCallback {
        static final int TRANSACTION_onActiveSipDialogsChanged = 1;

        public Stub() {
            this.attachInterface(this, ISipDialogStateCallback.DESCRIPTOR);
        }

        public static ISipDialogStateCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISipDialogStateCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ISipDialogStateCallback) {
                return (ISipDialogStateCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onActiveSipDialogsChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISipDialogStateCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ArrayList<SipDialogState> _arg0 = data.createTypedArrayList(SipDialogState.CREATOR);
                    data.enforceNoDataAvail();
                    this.onActiveSipDialogsChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements ISipDialogStateCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISipDialogStateCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActiveSipDialogsChanged(List<SipDialogState> dialogs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISipDialogStateCallback.DESCRIPTOR);
                    _data.writeTypedList(dialogs, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISipDialogStateCallback {
        @Override
        public void onActiveSipDialogsChanged(List<SipDialogState> dialogs) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

