/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telecom;

import android.telecom.PhoneAccountHandle;
import com.android.internal.telecom.ClientTransactionalServiceWrapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClientTransactionalServiceRepository {
    private static final Map<PhoneAccountHandle, ClientTransactionalServiceWrapper> LOOKUP_TABLE = new ConcurrentHashMap<PhoneAccountHandle, ClientTransactionalServiceWrapper>();

    public ClientTransactionalServiceWrapper addNewCallForTransactionalServiceWrapper(PhoneAccountHandle phoneAccountHandle) {
        ClientTransactionalServiceWrapper service = null;
        service = !this.hasExistingServiceWrapper(phoneAccountHandle) ? new ClientTransactionalServiceWrapper(phoneAccountHandle, this) : this.getTransactionalServiceWrapper(phoneAccountHandle);
        LOOKUP_TABLE.put(phoneAccountHandle, service);
        return service;
    }

    private ClientTransactionalServiceWrapper getTransactionalServiceWrapper(PhoneAccountHandle pah) {
        return LOOKUP_TABLE.get(pah);
    }

    private boolean hasExistingServiceWrapper(PhoneAccountHandle pah) {
        return LOOKUP_TABLE.containsKey(pah);
    }

    public boolean removeServiceWrapper(PhoneAccountHandle pah) {
        if (!this.hasExistingServiceWrapper(pah)) {
            return false;
        }
        LOOKUP_TABLE.remove(pah);
        return true;
    }

    public boolean removeCallFromServiceWrapper(PhoneAccountHandle pah, String callId) {
        if (!this.hasExistingServiceWrapper(pah)) {
            return false;
        }
        ClientTransactionalServiceWrapper service = LOOKUP_TABLE.get(pah);
        service.untrackCall(callId);
        return true;
    }
}

