/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.statusbar;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.InsetsFlags;
import android.view.ViewDebug;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class LetterboxDetails
implements Parcelable {
    @NonNull
    private final Rect mLetterboxInnerBounds;
    @NonNull
    private final Rect mLetterboxFullBounds;
    private final int mAppAppearance;
    @NonNull
    public static final Parcelable.Creator<LetterboxDetails> CREATOR = new Parcelable.Creator<LetterboxDetails>(){

        public LetterboxDetails[] newArray(int size) {
            return new LetterboxDetails[size];
        }

        @Override
        public LetterboxDetails createFromParcel(@NonNull Parcel in) {
            return new LetterboxDetails(in);
        }
    };

    @NonNull
    public Rect getLetterboxInnerBounds() {
        return this.mLetterboxInnerBounds;
    }

    @NonNull
    public Rect getLetterboxFullBounds() {
        return this.mLetterboxFullBounds;
    }

    public int getAppAppearance() {
        return this.mAppAppearance;
    }

    public String appAppearanceToString() {
        return ViewDebug.flagsToString(InsetsFlags.class, "appearance", this.mAppAppearance);
    }

    public LetterboxDetails(@NonNull Rect letterboxInnerBounds, @NonNull Rect letterboxFullBounds, int appAppearance) {
        this.mLetterboxInnerBounds = letterboxInnerBounds;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mLetterboxInnerBounds);
        this.mLetterboxFullBounds = letterboxFullBounds;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mLetterboxFullBounds);
        this.mAppAppearance = appAppearance;
    }

    public String toString() {
        return "LetterboxDetails { letterboxInnerBounds = " + this.mLetterboxInnerBounds + ", letterboxFullBounds = " + this.mLetterboxFullBounds + ", appAppearance = " + this.appAppearanceToString() + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LetterboxDetails that = (LetterboxDetails)o;
        return Objects.equals(this.mLetterboxInnerBounds, that.mLetterboxInnerBounds) && Objects.equals(this.mLetterboxFullBounds, that.mLetterboxFullBounds) && this.mAppAppearance == that.mAppAppearance;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mLetterboxInnerBounds);
        _hash = 31 * _hash + Objects.hashCode(this.mLetterboxFullBounds);
        _hash = 31 * _hash + this.mAppAppearance;
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mLetterboxInnerBounds, flags);
        dest.writeTypedObject(this.mLetterboxFullBounds, flags);
        dest.writeInt(this.mAppAppearance);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected LetterboxDetails(@NonNull Parcel in) {
        Rect letterboxInnerBounds = in.readTypedObject(Rect.CREATOR);
        Rect letterboxFullBounds = in.readTypedObject(Rect.CREATOR);
        int appAppearance = in.readInt();
        this.mLetterboxInnerBounds = letterboxInnerBounds;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mLetterboxInnerBounds);
        this.mLetterboxFullBounds = letterboxFullBounds;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mLetterboxFullBounds);
        this.mAppAppearance = appAppearance;
    }

    @Deprecated
    private void __metadata() {
    }
}

