/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.protolog;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.protolog.ProtoLog;
import com.android.internal.protolog.common.ILogger;
import com.android.internal.protolog.common.IProtoLog;
import com.android.internal.protolog.common.IProtoLogGroup;
import com.android.internal.protolog.common.LogLevel;
import java.util.Collections;
import java.util.List;

@RavenwoodKeepWholeClass
public class LogcatOnlyProtoLogImpl
implements IProtoLog {
    private static final String LOG_TAG = LogcatOnlyProtoLogImpl.class.getName();

    @Override
    public void log(@NonNull LogLevel logLevel, @NonNull IProtoLogGroup group, long messageHash, int paramsMask, @Nullable Object[] args) {
        throw new UnsupportedOperationException("Not supported when using LogcatOnlyProtoLogImpl");
    }

    @Override
    public void log(@NonNull LogLevel logLevel, @NonNull IProtoLogGroup group, @NonNull String messageString, @NonNull Object[] args) {
        if (ProtoLog.REQUIRE_PROTOLOGTOOL && group.isLogToProto()) {
            Log.w(LOG_TAG, "ProtoLog message not processed. Failed to log it to proto. Logging it below to logcat instead.");
        }
        if (group.isLogToLogcat() || group.isLogToProto()) {
            String formattedString = TextUtils.formatSimple(messageString, args);
            switch (logLevel) {
                case VERBOSE: {
                    Log.v(group.getTag(), formattedString);
                    break;
                }
                case INFO: {
                    Log.i(group.getTag(), formattedString);
                    break;
                }
                case DEBUG: {
                    Log.d(group.getTag(), formattedString);
                    break;
                }
                case WARN: {
                    Log.w(group.getTag(), formattedString);
                    break;
                }
                case ERROR: {
                    Log.e(group.getTag(), formattedString);
                    break;
                }
                case WTF: {
                    Log.wtf(group.getTag(), formattedString);
                }
            }
        }
    }

    @Override
    public boolean isProtoEnabled() {
        return false;
    }

    @Override
    public int startLoggingToLogcat(@NonNull String[] groups, @NonNull ILogger logger) {
        return 0;
    }

    @Override
    public int stopLoggingToLogcat(@NonNull String[] groups, @NonNull ILogger logger) {
        return 0;
    }

    @Override
    public boolean isEnabled(@NonNull IProtoLogGroup group, @NonNull LogLevel level) {
        return true;
    }

    @Override
    @NonNull
    public List<IProtoLogGroup> getRegisteredGroups() {
        return Collections.emptyList();
    }

    @Override
    public void registerGroups(IProtoLogGroup ... groups) {
    }
}

