/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.IntentFilter;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Parcelable;
import com.android.internal.R;
import com.android.internal.hidden_from_bootclasspath.android.multiuser.Flags;
import com.android.internal.pm.pkg.component.ComponentParseUtils;
import com.android.internal.pm.pkg.component.ParsedComponentUtils;
import com.android.internal.pm.pkg.component.ParsedIntentInfoImpl;
import com.android.internal.pm.pkg.component.ParsedMainComponentUtils;
import com.android.internal.pm.pkg.component.ParsedService;
import com.android.internal.pm.pkg.component.ParsedServiceImpl;
import com.android.internal.pm.pkg.parsing.ParsingPackage;
import com.android.internal.pm.pkg.parsing.ParsingPackageUtils;
import com.android.internal.pm.pkg.parsing.ParsingUtils;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

public class ParsedServiceUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ParseResult<ParsedService> parseService(String[] separateProcesses, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, boolean useRoundIcon, @Nullable String defaultSplitName, @NonNull ParseInput input) throws XmlPullParserException, IOException {
        int type;
        boolean visibleToEphemeral;
        boolean setExported;
        String packageName = pkg.getPackageName();
        ParsedServiceImpl service = new ParsedServiceImpl();
        String tag = parser.getName();
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestService);
        try {
            String permission2;
            ParseResult<ParsedServiceImpl> result = ParsedMainComponentUtils.parseMainComponent(service, tag, separateProcesses, pkg, sa, flags, useRoundIcon, defaultSplitName, input, 12, 7, 13, 4, 1, 0, 8, 2, 6, 15, 17, 20, 23);
            if (result.isError()) {
                ParseResult<ParsedService> parseResult = input.error(result);
                return parseResult;
            }
            setExported = sa.hasValue(5);
            if (setExported) {
                service.setExported(sa.getBoolean(5, false));
            }
            service.setPermission((permission2 = sa.getNonConfigurationString(3, 0)) != null ? permission2 : pkg.getPermission());
            service.setForegroundServiceType(sa.getInt(19, 0)).setFlags(service.getFlags() | (ComponentParseUtils.flag(1, 9, sa) | ComponentParseUtils.flag(2, 10, sa) | ComponentParseUtils.flag(4, 14, sa) | ComponentParseUtils.flag(8, 18, sa) | ComponentParseUtils.flag(16, 21, sa) | ComponentParseUtils.flag(0x40000000, 11, sa)));
            if (Flags.enableSystemUserOnlyForServicesAndProviders()) {
                service.setFlags(service.getFlags() | ComponentParseUtils.flag(0x20000000, 22, sa));
            }
            if (visibleToEphemeral = sa.getBoolean(16, false)) {
                service.setFlags(service.getFlags() | 0x100000);
                pkg.setVisibleToInstantApps(true);
            }
        }
        finally {
            sa.recycle();
        }
        if (pkg.isSaveStateDisallowed() && Objects.equals(service.getProcessName(), packageName)) {
            return input.error("Heavy-weight applications can not have services in main process");
        }
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<Parcelable> parseResult;
            if (type != 2) continue;
            if (ParsingPackageUtils.getAconfigFlags().skipCurrentElement(pkg, parser)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            switch (parser.getName()) {
                case "intent-filter": {
                    ParseResult<ParsedIntentInfoImpl> intentResult = ParsedMainComponentUtils.parseIntentFilter(service, pkg, res, parser, visibleToEphemeral, true, false, false, false, input);
                    parseResult = intentResult;
                    if (!intentResult.isSuccess()) break;
                    ParsedIntentInfoImpl intent = intentResult.getResult();
                    IntentFilter intentFilter = intent.getIntentFilter();
                    service.setOrder(Math.max(intentFilter.getOrder(), service.getOrder()));
                    service.addIntent(intent);
                    break;
                }
                case "meta-data": {
                    parseResult = ParsedComponentUtils.addMetaData(service, pkg, res, parser, input);
                    break;
                }
                case "property": {
                    parseResult = ParsedComponentUtils.addProperty(service, pkg, res, parser, input);
                    break;
                }
                default: {
                    parseResult = ParsingUtils.unknownTag(tag, pkg, parser, input);
                }
            }
            if (!parseResult.isError()) continue;
            return input.error(parseResult);
        }
        if (!setExported) {
            ParseResult<?> exportedCheckResult;
            boolean hasIntentFilters;
            boolean bl = hasIntentFilters = service.getIntents().size() > 0;
            if (hasIntentFilters && (exportedCheckResult = input.deferError(service.getName() + ": Targeting S+ (version " + 31 + " and above) requires that an explicit value for android:exported be defined when intent filters are present", 150232615L)).isError()) {
                return input.error(exportedCheckResult);
            }
            service.setExported(hasIntentFilters);
        }
        return input.success(service);
    }
}

