/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.content.pm.ApplicationInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.internal.pm.pkg.component.ParsedProcess;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.Parcelling;
import java.util.Collections;
import java.util.Set;

public class ParsedProcessImpl
implements ParsedProcess,
Parcelable {
    @NonNull
    private String name;
    @NonNull
    private ArrayMap<String, String> appClassNamesByPackage = ArrayMap.EMPTY;
    @NonNull
    private Set<String> deniedPermissions = Collections.emptySet();
    private int gwpAsanMode = -1;
    private int memtagMode = -1;
    private int nativeHeapZeroInitialized = -1;
    private boolean useEmbeddedDex;
    static Parcelling<Set<String>> sParcellingForDeniedPermissions = Parcelling.Cache.get(Parcelling.BuiltIn.ForInternedStringSet.class);
    @NonNull
    public static final Parcelable.Creator<ParsedProcessImpl> CREATOR;

    public ParsedProcessImpl() {
    }

    public ParsedProcessImpl(@NonNull ParsedProcess other) {
        this.name = other.getName();
        this.appClassNamesByPackage = other.getAppClassNamesByPackage().size() == 0 ? ArrayMap.EMPTY : new ArrayMap<String, String>(other.getAppClassNamesByPackage());
        this.deniedPermissions = new ArraySet<String>(other.getDeniedPermissions());
        this.gwpAsanMode = other.getGwpAsanMode();
        this.memtagMode = other.getMemtagMode();
        this.nativeHeapZeroInitialized = other.getNativeHeapZeroInitialized();
        this.useEmbeddedDex = other.isUseEmbeddedDex();
    }

    public void addStateFrom(@NonNull ParsedProcess other) {
        this.deniedPermissions = CollectionUtils.addAll(this.deniedPermissions, other.getDeniedPermissions());
        this.gwpAsanMode = other.getGwpAsanMode();
        this.memtagMode = other.getMemtagMode();
        this.nativeHeapZeroInitialized = other.getNativeHeapZeroInitialized();
        this.useEmbeddedDex = other.isUseEmbeddedDex();
        ArrayMap<String, String> oacn = other.getAppClassNamesByPackage();
        for (int i = 0; i < oacn.size(); ++i) {
            this.appClassNamesByPackage.put(oacn.keyAt(i), oacn.valueAt(i));
        }
    }

    public void putAppClassNameForPackage(String packageName, String className) {
        if (this.appClassNamesByPackage.size() == 0) {
            this.appClassNamesByPackage = new ArrayMap(4);
        }
        this.appClassNamesByPackage.put(packageName, className);
    }

    public ParsedProcessImpl(@NonNull String name, @NonNull ArrayMap<String, String> appClassNamesByPackage, @NonNull Set<String> deniedPermissions, int gwpAsanMode, int memtagMode, int nativeHeapZeroInitialized, boolean useEmbeddedDex) {
        this.name = name;
        AnnotationValidations.validate(NonNull.class, null, (Object)name);
        this.appClassNamesByPackage = appClassNamesByPackage;
        AnnotationValidations.validate(NonNull.class, null, appClassNamesByPackage);
        this.deniedPermissions = deniedPermissions;
        AnnotationValidations.validate(NonNull.class, null, deniedPermissions);
        this.gwpAsanMode = gwpAsanMode;
        AnnotationValidations.validate(ApplicationInfo.GwpAsanMode.class, null, gwpAsanMode);
        this.memtagMode = memtagMode;
        AnnotationValidations.validate(ApplicationInfo.MemtagMode.class, null, memtagMode);
        this.nativeHeapZeroInitialized = nativeHeapZeroInitialized;
        AnnotationValidations.validate(ApplicationInfo.NativeHeapZeroInitialized.class, null, nativeHeapZeroInitialized);
        this.useEmbeddedDex = useEmbeddedDex;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public ArrayMap<String, String> getAppClassNamesByPackage() {
        return this.appClassNamesByPackage;
    }

    @Override
    @NonNull
    public Set<String> getDeniedPermissions() {
        return this.deniedPermissions;
    }

    @Override
    public int getGwpAsanMode() {
        return this.gwpAsanMode;
    }

    @Override
    public int getMemtagMode() {
        return this.memtagMode;
    }

    @Override
    public int getNativeHeapZeroInitialized() {
        return this.nativeHeapZeroInitialized;
    }

    @Override
    public boolean isUseEmbeddedDex() {
        return this.useEmbeddedDex;
    }

    @NonNull
    public ParsedProcessImpl setName(@NonNull String value) {
        this.name = value;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.name);
        return this;
    }

    @NonNull
    public ParsedProcessImpl setAppClassNamesByPackage(@NonNull ArrayMap<String, String> value) {
        this.appClassNamesByPackage = value;
        AnnotationValidations.validate(NonNull.class, null, this.appClassNamesByPackage);
        return this;
    }

    @NonNull
    public ParsedProcessImpl setDeniedPermissions(@NonNull Set<String> value) {
        this.deniedPermissions = value;
        AnnotationValidations.validate(NonNull.class, null, this.deniedPermissions);
        return this;
    }

    @NonNull
    public ParsedProcessImpl setGwpAsanMode(int value) {
        this.gwpAsanMode = value;
        AnnotationValidations.validate(ApplicationInfo.GwpAsanMode.class, null, this.gwpAsanMode);
        return this;
    }

    @NonNull
    public ParsedProcessImpl setMemtagMode(int value) {
        this.memtagMode = value;
        AnnotationValidations.validate(ApplicationInfo.MemtagMode.class, null, this.memtagMode);
        return this;
    }

    @NonNull
    public ParsedProcessImpl setNativeHeapZeroInitialized(int value) {
        this.nativeHeapZeroInitialized = value;
        AnnotationValidations.validate(ApplicationInfo.NativeHeapZeroInitialized.class, null, this.nativeHeapZeroInitialized);
        return this;
    }

    @NonNull
    public ParsedProcessImpl setUseEmbeddedDex(boolean value) {
        this.useEmbeddedDex = value;
        return this;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.useEmbeddedDex) {
            flg = (byte)(flg | 0x40);
        }
        dest.writeByte(flg);
        dest.writeString(this.name);
        dest.writeMap(this.appClassNamesByPackage);
        sParcellingForDeniedPermissions.parcel(this.deniedPermissions, dest, flags);
        dest.writeInt(this.gwpAsanMode);
        dest.writeInt(this.memtagMode);
        dest.writeInt(this.nativeHeapZeroInitialized);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected ParsedProcessImpl(@NonNull Parcel in) {
        byte flg = in.readByte();
        boolean _useEmbeddedDex = (flg & 0x40) != 0;
        String _name = in.readString();
        ArrayMap _appClassNamesByPackage = new ArrayMap();
        in.readMap(_appClassNamesByPackage, String.class.getClassLoader());
        Set<String> _deniedPermissions = sParcellingForDeniedPermissions.unparcel(in);
        int _gwpAsanMode = in.readInt();
        int _memtagMode = in.readInt();
        int _nativeHeapZeroInitialized = in.readInt();
        this.name = _name;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.name);
        this.appClassNamesByPackage = _appClassNamesByPackage;
        AnnotationValidations.validate(NonNull.class, null, this.appClassNamesByPackage);
        this.deniedPermissions = _deniedPermissions;
        AnnotationValidations.validate(NonNull.class, null, this.deniedPermissions);
        this.gwpAsanMode = _gwpAsanMode;
        AnnotationValidations.validate(ApplicationInfo.GwpAsanMode.class, null, this.gwpAsanMode);
        this.memtagMode = _memtagMode;
        AnnotationValidations.validate(ApplicationInfo.MemtagMode.class, null, this.memtagMode);
        this.nativeHeapZeroInitialized = _nativeHeapZeroInitialized;
        AnnotationValidations.validate(ApplicationInfo.NativeHeapZeroInitialized.class, null, this.nativeHeapZeroInitialized);
        this.useEmbeddedDex = _useEmbeddedDex;
    }

    @Deprecated
    private void __metadata() {
    }

    static {
        if (sParcellingForDeniedPermissions == null) {
            sParcellingForDeniedPermissions = Parcelling.Cache.put(new Parcelling.BuiltIn.ForInternedStringSet());
        }
        CREATOR = new Parcelable.Creator<ParsedProcessImpl>(){

            public ParsedProcessImpl[] newArray(int size) {
                return new ParsedProcessImpl[size];
            }

            @Override
            public ParsedProcessImpl createFromParcel(@NonNull Parcel in) {
                return new ParsedProcessImpl(in);
            }
        };
    }
}

