/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.pm.parsing.pkg.PackageImpl;
import com.android.internal.pm.pkg.component.ParsedComponentImpl;
import com.android.internal.pm.pkg.component.ParsedMainComponent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.util.EmptyArray;

public class ParsedMainComponentImpl
extends ParsedComponentImpl
implements ParsedMainComponent,
Parcelable {
    @Nullable
    private String processName;
    private boolean directBootAware;
    private boolean enabled = true;
    private boolean exported;
    private int order;
    @Nullable
    private String splitName;
    @Nullable
    private String[] attributionTags;
    private int mIntentMatchingFlags;
    public static final int INTENT_MATCHING_FLAGS_NONE = 1;
    public static final int INTENT_MATCHING_FLAGS_ENFORCE_INTENT_FILTER = 2;
    public static final int INTENT_MATCHING_FLAGS_ALLOW_NULL_ACTION = 4;
    public static final Parcelable.Creator<ParsedMainComponentImpl> CREATOR = new Parcelable.Creator<ParsedMainComponentImpl>(){

        @Override
        public ParsedMainComponentImpl createFromParcel(Parcel source) {
            return new ParsedMainComponentImpl(source);
        }

        public ParsedMainComponentImpl[] newArray(int size) {
            return new ParsedMainComponentImpl[size];
        }
    };

    public ParsedMainComponentImpl() {
    }

    public ParsedMainComponentImpl(ParsedMainComponent other) {
        super(other);
        this.processName = other.getProcessName();
        this.directBootAware = other.isDirectBootAware();
        this.enabled = other.isEnabled();
        this.exported = other.isExported();
        this.order = other.getOrder();
        this.splitName = other.getSplitName();
        this.attributionTags = other.getAttributionTags();
    }

    public ParsedMainComponentImpl setProcessName(String processName) {
        this.processName = TextUtils.safeIntern(processName);
        return this;
    }

    @Override
    public String getClassName() {
        return this.getName();
    }

    @Override
    @NonNull
    public String[] getAttributionTags() {
        return this.attributionTags == null ? EmptyArray.STRING : this.attributionTags;
    }

    public ParsedMainComponent setIntentMatchingFlags(int intentMatchingFlags) {
        this.mIntentMatchingFlags = intentMatchingFlags;
        return this;
    }

    @Override
    public int getIntentMatchingFlags() {
        return this.mIntentMatchingFlags;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        PackageImpl.sForInternedString.parcel(this.processName, dest, flags);
        dest.writeBoolean(this.directBootAware);
        dest.writeBoolean(this.enabled);
        dest.writeBoolean(this.exported);
        dest.writeInt(this.order);
        dest.writeString(this.splitName);
        dest.writeString8Array(this.attributionTags);
        dest.writeInt(this.mIntentMatchingFlags);
    }

    protected ParsedMainComponentImpl(Parcel in) {
        super(in);
        this.processName = PackageImpl.sForInternedString.unparcel(in);
        this.directBootAware = in.readBoolean();
        this.enabled = in.readBoolean();
        this.exported = in.readBoolean();
        this.order = in.readInt();
        this.splitName = in.readString();
        this.attributionTags = in.createString8Array();
        this.mIntentMatchingFlags = in.readInt();
    }

    public static String intentMatchingFlagsToString(int value) {
        switch (value) {
            case 1: {
                return "INTENT_MATCHING_FLAGS_NONE";
            }
            case 2: {
                return "INTENT_MATCHING_FLAGS_ENFORCE_INTENT_FILTER";
            }
            case 4: {
                return "INTENT_MATCHING_FLAGS_ALLOW_NULL_ACTION";
            }
        }
        return Integer.toHexString(value);
    }

    public ParsedMainComponentImpl(@Nullable String processName, boolean directBootAware, boolean enabled, boolean exported, int order, @Nullable String splitName, @Nullable String[] attributionTags, int intentMatchingFlags) {
        this.processName = processName;
        this.directBootAware = directBootAware;
        this.enabled = enabled;
        this.exported = exported;
        this.order = order;
        this.splitName = splitName;
        this.attributionTags = attributionTags;
        this.mIntentMatchingFlags = intentMatchingFlags;
    }

    @Override
    @Nullable
    public String getProcessName() {
        return this.processName;
    }

    @Override
    public boolean isDirectBootAware() {
        return this.directBootAware;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isExported() {
        return this.exported;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    @Nullable
    public String getSplitName() {
        return this.splitName;
    }

    @NonNull
    public ParsedMainComponentImpl setDirectBootAware(boolean value) {
        this.directBootAware = value;
        return this;
    }

    @NonNull
    public ParsedMainComponentImpl setEnabled(boolean value) {
        this.enabled = value;
        return this;
    }

    @NonNull
    public ParsedMainComponentImpl setExported(boolean value) {
        this.exported = value;
        return this;
    }

    @NonNull
    public ParsedMainComponentImpl setOrder(int value) {
        this.order = value;
        return this;
    }

    @NonNull
    public ParsedMainComponentImpl setSplitName(@NonNull String value) {
        this.splitName = value;
        return this;
    }

    @NonNull
    public ParsedMainComponentImpl setAttributionTags(String ... value) {
        this.attributionTags = value;
        return this;
    }

    @Deprecated
    private void __metadata() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IntentMatchingFlags {
    }
}

