/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.server.pm.pkg.AndroidPackageSplit;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AndroidPackageSplitImpl
implements AndroidPackageSplit {
    @Nullable
    private final String mName;
    @NonNull
    private final String mPath;
    private final int mRevisionCode;
    private final int mFlags;
    @Nullable
    private final String mClassLoaderName;
    @NonNull
    private List<AndroidPackageSplit> mDependencies = Collections.emptyList();

    public AndroidPackageSplitImpl(@Nullable String name, @NonNull String path, int revisionCode, int flags, @Nullable String classLoaderName) {
        this.mName = name;
        this.mPath = path;
        this.mRevisionCode = revisionCode;
        this.mFlags = flags;
        this.mClassLoaderName = classLoaderName;
    }

    public void fillDependencies(@NonNull List<AndroidPackageSplit> splits) {
        if (!this.mDependencies.isEmpty()) {
            throw new IllegalStateException("Cannot fill split dependencies more than once");
        }
        this.mDependencies = splits;
    }

    @Override
    @Nullable
    public String getName() {
        return this.mName;
    }

    @Override
    @NonNull
    public String getPath() {
        return this.mPath;
    }

    @Override
    public int getRevisionCode() {
        return this.mRevisionCode;
    }

    @Override
    public boolean isHasCode() {
        return (this.mFlags & 4) != 0;
    }

    @Override
    @Nullable
    public String getClassLoaderName() {
        return this.mClassLoaderName;
    }

    @Override
    @NonNull
    public List<AndroidPackageSplit> getDependencies() {
        return this.mDependencies;
    }

    public boolean equals(Object o) {
        boolean fieldsEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof AndroidPackageSplitImpl)) {
            return false;
        }
        AndroidPackageSplitImpl that = (AndroidPackageSplitImpl)o;
        boolean bl = fieldsEqual = this.mRevisionCode == that.mRevisionCode && this.mFlags == that.mFlags && Objects.equals(this.mName, that.mName) && Objects.equals(this.mPath, that.mPath) && Objects.equals(this.mClassLoaderName, that.mClassLoaderName);
        if (!fieldsEqual) {
            return false;
        }
        if (this.mDependencies.size() != that.mDependencies.size()) {
            return false;
        }
        for (int index = 0; index < this.mDependencies.size(); ++index) {
            if (Objects.equals(this.mDependencies.get(index).getName(), that.mDependencies.get(index).getName())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int dependenciesHash = Objects.hash(this.mName, this.mPath, this.mRevisionCode, this.mFlags, this.mClassLoaderName);
        for (int index = 0; index < this.mDependencies.size(); ++index) {
            String name = this.mDependencies.get(index).getName();
            dependenciesHash = 31 * dependenciesHash + (name == null ? 0 : name.hashCode());
        }
        return dependenciesHash;
    }
}

