/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os.anr;

import android.os.SystemClock;
import android.os.Trace;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FrameworkStatsLog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.atomic.AtomicInteger;

public class AnrLatencyTracker
implements AutoCloseable {
    private static final AtomicInteger sNextAnrRecordPlacedOnQueueCookieGenerator = new AtomicInteger();
    private long mAnrTriggerUptime;
    private long mEndUptime;
    private long mAppNotRespondingStartUptime;
    private long mAnrRecordPlacedOnQueueUptime;
    private long mAnrProcessingStartedUptime;
    private long mDumpStackTracesStartUptime;
    private long mUpdateCpuStatsNowLastCallUptime;
    private long mUpdateCpuStatsNowTotalLatency = 0L;
    private long mCurrentPsiStateLastCallUptime;
    private long mCurrentPsiStateTotalLatency = 0L;
    private long mProcessCpuTrackerMethodsLastCallUptime;
    private long mProcessCpuTrackerMethodsTotalLatency = 0L;
    private long mCriticalEventLoglastCallUptime;
    private long mCriticalEventLogTotalLatency = 0L;
    private long mGlobalLockLastTryAcquireStart;
    private long mGlobalLockTotalContention = 0L;
    private long mPidLockLastTryAcquireStart;
    private long mPidLockTotalContention = 0L;
    private long mAMSLockLastTryAcquireStart;
    private long mAMSLockTotalContention = 0L;
    private long mProcLockLastTryAcquireStart;
    private long mProcLockTotalContention = 0L;
    private long mAnrRecordLastTryAcquireStart;
    private long mAnrRecordLockTotalContention = 0L;
    private int mAnrQueueSize;
    private int mAnrType;
    private final AtomicInteger mDumpedProcessesCount = new AtomicInteger(0);
    private volatile int mEarlyDumpStatus = 1;
    private volatile long mTempFileDumpingStartUptime;
    private volatile long mTempFileDumpingDuration = 0L;
    private long mCopyingFirstPidStartUptime;
    private long mCopyingFirstPidDuration = 0L;
    private long mEarlyDumpRequestSubmissionUptime = 0L;
    private long mEarlyDumpExecutorPidCount = 0L;
    private long mFirstPidsDumpingStartUptime;
    private long mFirstPidsDumpingDuration = 0L;
    private long mNativePidsDumpingStartUptime;
    private long mNativePidsDumpingDuration = 0L;
    private long mExtraPidsDumpingStartUptime;
    private long mExtraPidsDumpingDuration = 0L;
    private boolean mIsPushed = false;
    private boolean mIsSkipped = false;
    private boolean mCopyingFirstPidSucceeded = false;
    private long mPreDumpIfLockTooSlowStartUptime;
    private long mPreDumpIfLockTooSlowDuration = 0L;
    private long mNotifyAppUnresponsiveStartUptime;
    private long mNotifyAppUnresponsiveDuration = 0L;
    private long mNotifyWindowUnresponsiveStartUptime;
    private long mNotifyWindowUnresponsiveDuration = 0L;
    private final int mAnrRecordPlacedOnQueueCookie = sNextAnrRecordPlacedOnQueueCookieGenerator.incrementAndGet();

    public AnrLatencyTracker(int timeoutKind, long anrTriggerUptime) {
        this.mAnrTriggerUptime = anrTriggerUptime;
        this.mAnrType = AnrLatencyTracker.timeoutKindToAnrType(timeoutKind);
    }

    public void appNotRespondingStarted() {
        this.mAppNotRespondingStartUptime = this.getUptimeMillis();
        Trace.traceBegin(64L, "AnrHelper#appNotResponding()");
    }

    public void appNotRespondingEnded() {
        Trace.traceEnd(64L);
    }

    public void earlyDumpRequestSubmittedWithSize(int currentProcessedPidCount) {
        this.mEarlyDumpRequestSubmissionUptime = this.getUptimeMillis();
        this.mEarlyDumpExecutorPidCount = currentProcessedPidCount;
    }

    public void anrRecordPlacingOnQueueWithSize(int queueSize) {
        this.mAnrRecordPlacedOnQueueUptime = this.getUptimeMillis();
        Trace.asyncTraceBegin(64L, "anrRecordPlacedOnQueue", this.mAnrRecordPlacedOnQueueCookie);
        this.mAnrQueueSize = queueSize;
        Trace.traceCounter(64L, "anrRecordsQueueSize", queueSize + 1);
    }

    public void anrProcessingStarted() {
        this.mAnrProcessingStartedUptime = this.getUptimeMillis();
        Trace.asyncTraceEnd(64L, "anrRecordPlacedOnQueue", this.mAnrRecordPlacedOnQueueCookie);
        Trace.traceBegin(64L, "anrProcessing");
    }

    public void anrProcessingEnded() {
        Trace.traceEnd(64L);
        this.close();
    }

    public void dumpStackTracesStarted() {
        this.mDumpStackTracesStartUptime = this.getUptimeMillis();
        Trace.traceBegin(64L, "dumpStackTraces()");
    }

    public void dumpStackTracesEnded() {
        Trace.traceEnd(64L);
    }

    public void updateCpuStatsNowCalled() {
        this.mUpdateCpuStatsNowLastCallUptime = this.getUptimeMillis();
        Trace.traceBegin(64L, "updateCpuStatsNow()");
    }

    public void updateCpuStatsNowReturned() {
        this.mUpdateCpuStatsNowTotalLatency += this.getUptimeMillis() - this.mUpdateCpuStatsNowLastCallUptime;
        Trace.traceEnd(64L);
    }

    public void currentPsiStateCalled() {
        this.mCurrentPsiStateLastCallUptime = this.getUptimeMillis();
        Trace.traceBegin(64L, "currentPsiState()");
    }

    public void currentPsiStateReturned() {
        this.mCurrentPsiStateTotalLatency += this.getUptimeMillis() - this.mCurrentPsiStateLastCallUptime;
        Trace.traceEnd(64L);
    }

    public void processCpuTrackerMethodsCalled() {
        this.mProcessCpuTrackerMethodsLastCallUptime = this.getUptimeMillis();
        Trace.traceBegin(64L, "processCpuTracker");
    }

    public void processCpuTrackerMethodsReturned() {
        this.mProcessCpuTrackerMethodsTotalLatency += this.getUptimeMillis() - this.mProcessCpuTrackerMethodsLastCallUptime;
        Trace.traceEnd(64L);
    }

    public void criticalEventLogStarted() {
        this.mCriticalEventLoglastCallUptime = this.getUptimeMillis();
        Trace.traceBegin(64L, "criticalEventLog");
    }

    public void criticalEventLogEnded() {
        this.mCriticalEventLogTotalLatency += this.getUptimeMillis() - this.mCriticalEventLoglastCallUptime;
        Trace.traceEnd(64L);
    }

    public void nativePidCollectionStarted() {
        Trace.traceBegin(64L, "nativePidCollection");
    }

    public void nativePidCollectionEnded() {
        Trace.traceEnd(64L);
    }

    public void dumpingPidStarted(int pid) {
        Trace.traceBegin(64L, "dumpingPid#" + pid);
    }

    public void dumpingPidEnded() {
        this.mDumpedProcessesCount.incrementAndGet();
        Trace.traceEnd(64L);
    }

    public void dumpingFirstPidsStarted() {
        this.mFirstPidsDumpingStartUptime = this.getUptimeMillis();
        Trace.traceBegin(64L, "dumpingFirstPids");
    }

    public void dumpingFirstPidsEnded() {
        this.mFirstPidsDumpingDuration = this.getUptimeMillis() - this.mFirstPidsDumpingStartUptime;
        Trace.traceEnd(64L);
    }

    public void copyingFirstPidStarted() {
        this.mCopyingFirstPidStartUptime = this.getUptimeMillis();
        Trace.traceBegin(64L, "copyingFirstPid");
    }

    public void copyingFirstPidEnded(boolean copySucceeded) {
        this.mCopyingFirstPidDuration = this.getUptimeMillis() - this.mCopyingFirstPidStartUptime;
        this.mCopyingFirstPidSucceeded = copySucceeded;
        Trace.traceEnd(64L);
    }

    public void dumpStackTracesTempFileStarted() {
        this.mTempFileDumpingStartUptime = this.getUptimeMillis();
        Trace.traceBegin(64L, "dumpStackTracesTempFile");
    }

    public void dumpStackTracesTempFileEnded() {
        this.mTempFileDumpingDuration = this.getUptimeMillis() - this.mTempFileDumpingStartUptime;
        if (this.mEarlyDumpStatus == 1) {
            this.mEarlyDumpStatus = 2;
        }
        Trace.traceEnd(64L);
    }

    public void dumpStackTracesTempFileCreationFailed() {
        this.mEarlyDumpStatus = 3;
        Trace.instant(64L, "dumpStackTracesTempFileCreationFailed");
    }

    public void dumpStackTracesTempFileTimedOut() {
        this.mEarlyDumpStatus = 4;
        Trace.instant(64L, "dumpStackTracesTempFileTimedOut");
    }

    public void dumpingNativePidsStarted() {
        this.mNativePidsDumpingStartUptime = this.getUptimeMillis();
        Trace.traceBegin(64L, "dumpingNativePids");
    }

    public void dumpingNativePidsEnded() {
        this.mNativePidsDumpingDuration = this.getUptimeMillis() - this.mNativePidsDumpingStartUptime;
        Trace.traceEnd(64L);
    }

    public void dumpingExtraPidsStarted() {
        this.mExtraPidsDumpingStartUptime = this.getUptimeMillis();
        Trace.traceBegin(64L, "dumpingExtraPids");
    }

    public void dumpingExtraPidsEnded() {
        this.mExtraPidsDumpingDuration = this.getUptimeMillis() - this.mExtraPidsDumpingStartUptime;
        Trace.traceEnd(64L);
    }

    public void waitingOnGlobalLockStarted() {
        this.mGlobalLockLastTryAcquireStart = this.getUptimeMillis();
        Trace.traceBegin(64L, "globalLock");
    }

    public void waitingOnGlobalLockEnded() {
        this.mGlobalLockTotalContention += this.getUptimeMillis() - this.mGlobalLockLastTryAcquireStart;
        Trace.traceEnd(64L);
    }

    public void waitingOnPidLockStarted() {
        this.mPidLockLastTryAcquireStart = this.getUptimeMillis();
        Trace.traceBegin(64L, "pidLockContention");
    }

    public void waitingOnPidLockEnded() {
        this.mPidLockTotalContention += this.getUptimeMillis() - this.mPidLockLastTryAcquireStart;
        Trace.traceEnd(64L);
    }

    public void waitingOnAMSLockStarted() {
        this.mAMSLockLastTryAcquireStart = this.getUptimeMillis();
        Trace.traceBegin(64L, "AMSLockContention");
    }

    public void waitingOnAMSLockEnded() {
        this.mAMSLockTotalContention += this.getUptimeMillis() - this.mAMSLockLastTryAcquireStart;
        Trace.traceEnd(64L);
    }

    public void waitingOnProcLockStarted() {
        this.mProcLockLastTryAcquireStart = this.getUptimeMillis();
        Trace.traceBegin(64L, "procLockContention");
    }

    public void waitingOnProcLockEnded() {
        this.mProcLockTotalContention += this.getUptimeMillis() - this.mProcLockLastTryAcquireStart;
        Trace.traceEnd(64L);
    }

    public void waitingOnAnrRecordLockStarted() {
        this.mAnrRecordLastTryAcquireStart = this.getUptimeMillis();
        Trace.traceBegin(64L, "anrRecordLockContention");
    }

    public void waitingOnAnrRecordLockEnded() {
        this.mAnrRecordLockTotalContention += this.getUptimeMillis() - this.mAnrRecordLastTryAcquireStart;
        Trace.traceEnd(64L);
    }

    public void anrRecordsQueueSizeWhenPopped(int queueSize) {
        Trace.traceCounter(64L, "anrRecordsQueueSize", queueSize);
    }

    public void preDumpIfLockTooSlowStarted() {
        this.mPreDumpIfLockTooSlowStartUptime = this.getUptimeMillis();
    }

    public void preDumpIfLockTooSlowEnded() {
        this.mPreDumpIfLockTooSlowDuration += this.getUptimeMillis() - this.mPreDumpIfLockTooSlowStartUptime;
    }

    public void anrSkippedProcessErrorStateRecordAppNotResponding() {
        this.anrSkipped("appNotResponding");
    }

    public void anrSkippedDumpStackTraces() {
        this.anrSkipped("dumpStackTraces");
    }

    public void notifyAppUnresponsiveStarted() {
        this.mNotifyAppUnresponsiveStartUptime = this.getUptimeMillis();
        Trace.traceBegin(64L, "notifyAppUnresponsive()");
    }

    public void notifyAppUnresponsiveEnded() {
        this.mNotifyAppUnresponsiveDuration = this.getUptimeMillis() - this.mNotifyAppUnresponsiveStartUptime;
        Trace.traceEnd(64L);
    }

    public void notifyWindowUnresponsiveStarted() {
        this.mNotifyWindowUnresponsiveStartUptime = this.getUptimeMillis();
        Trace.traceBegin(64L, "notifyWindowUnresponsive()");
    }

    public void notifyWindowUnresponsiveEnded() {
        this.mNotifyWindowUnresponsiveDuration = this.getUptimeMillis() - this.mNotifyWindowUnresponsiveStartUptime;
        Trace.traceEnd(64L);
    }

    public String dumpAsCommaSeparatedArrayWithHeader() {
        return "DurationsV5: " + this.mAnrTriggerUptime + "," + (this.mAppNotRespondingStartUptime - this.mAnrTriggerUptime) + "," + (this.mAnrRecordPlacedOnQueueUptime - this.mAppNotRespondingStartUptime) + "," + (this.mAnrProcessingStartedUptime - this.mAnrRecordPlacedOnQueueUptime) + "," + (this.mDumpStackTracesStartUptime - this.mAnrProcessingStartedUptime) + "," + this.mUpdateCpuStatsNowTotalLatency + "," + this.mCurrentPsiStateTotalLatency + "," + this.mProcessCpuTrackerMethodsTotalLatency + "," + this.mCriticalEventLogTotalLatency + "," + this.mGlobalLockTotalContention + "," + this.mPidLockTotalContention + "," + this.mAMSLockTotalContention + "," + this.mProcLockTotalContention + "," + this.mAnrRecordLockTotalContention + "," + this.mAnrQueueSize + "," + ((this.mFirstPidsDumpingStartUptime > 0L ? this.mFirstPidsDumpingStartUptime : this.mCopyingFirstPidStartUptime) - this.mDumpStackTracesStartUptime) + "," + this.mTempFileDumpingDuration + "," + (this.mTempFileDumpingStartUptime - this.mEarlyDumpRequestSubmissionUptime) + "," + this.mEarlyDumpExecutorPidCount + "," + this.mCopyingFirstPidDuration + "," + this.mEarlyDumpStatus + "," + (this.mCopyingFirstPidSucceeded ? 1 : 0) + "," + this.mPreDumpIfLockTooSlowDuration + "," + this.mNotifyAppUnresponsiveDuration + "," + this.mNotifyWindowUnresponsiveDuration + "\n\n";
    }

    @Override
    public void close() {
        if (!this.mIsSkipped && !this.mIsPushed) {
            this.mEndUptime = this.getUptimeMillis();
            this.pushAtom();
            this.mIsPushed = true;
        }
    }

    private static int timeoutKindToAnrType(int timeoutKind) {
        switch (timeoutKind) {
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 8;
            }
        }
        return 0;
    }

    @VisibleForTesting
    public long getUptimeMillis() {
        return SystemClock.uptimeMillis();
    }

    @VisibleForTesting
    public void pushAtom() {
        FrameworkStatsLog.write(516, this.mEndUptime - this.mAnrTriggerUptime, this.mFirstPidsDumpingStartUptime - this.mAnrTriggerUptime, this.mAppNotRespondingStartUptime - this.mAnrTriggerUptime, this.mAnrRecordPlacedOnQueueUptime - this.mAppNotRespondingStartUptime, this.mAnrProcessingStartedUptime - this.mAnrRecordPlacedOnQueueUptime, this.mDumpStackTracesStartUptime - this.mAnrProcessingStartedUptime, this.mFirstPidsDumpingDuration + this.mNativePidsDumpingDuration + this.mExtraPidsDumpingDuration, this.mUpdateCpuStatsNowTotalLatency, this.mCurrentPsiStateTotalLatency, this.mProcessCpuTrackerMethodsTotalLatency, this.mCriticalEventLogTotalLatency, this.mGlobalLockTotalContention, this.mPidLockTotalContention, this.mAMSLockTotalContention, this.mProcLockTotalContention, this.mAnrRecordLockTotalContention, this.mAnrQueueSize, this.mAnrType, this.mDumpedProcessesCount.get());
    }

    private void anrSkipped(String method) {
        Trace.instant(64L, "AnrSkipped@" + method);
        this.mIsSkipped = true;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface EarlyDumpStatus {
        public static final int UNKNOWN = 1;
        public static final int SUCCEEDED = 2;
        public static final int FAILED_TO_CREATE_FILE = 3;
        public static final int TIMED_OUT = 4;
    }
}

