/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.ApplicationErrorReport;
import android.app.IActivityManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.type.DefaultMimeMapFactory;
import android.ddm.DdmRegister;
import android.net.TrafficStats;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Process;
import android.os.SystemProperties;
import android.os.Trace;
import android.os._Original_Build;
import android.ravenwood.annotation.RavenwoodKeepPartialClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.util.Log;
import android.util.Slog;
import com.android.internal.logging.AndroidConfig;
import com.android.internal.os.AndroidPrintStream;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.RuntimeHooks;
import dalvik.system.VMRuntime;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.logging.LogManager;
import libcore.content.type.MimeMap;

@RavenwoodKeepPartialClass
public class RuntimeInit {
    static final String TAG = "AndroidRuntime";
    static final boolean DEBUG = false;
    @UnsupportedAppUsage
    private static boolean initialized;
    @UnsupportedAppUsage
    private static IBinder mApplicationObject;
    private static volatile boolean mCrashing;
    private static final String SYSPROP_CRASH_COUNT = "sys.system_server.crash_java";
    private static int mCrashCount;
    private static volatile ApplicationWtfHandler sDefaultApplicationWtfHandler;
    public static PrintStream sOut$ravenwood;
    public static PrintStream sErr$ravenwood;

    private static void nativeFinishInit() {
        OverrideMethod.invokeV("com.android.internal.os.RuntimeInit#nativeFinishInit()V", true, null);
    }

    private static void nativeSetExitWithoutCleanup(boolean bl) {
        OverrideMethod.invokeV("com.android.internal.os.RuntimeInit#nativeSetExitWithoutCleanup(Z)V", true, null);
    }

    private static int Clog_e(String tag, String msg, Throwable tr) {
        return Log.printlns(4, 6, tag, msg, tr);
    }

    public static void logUncaught(String threadName, String processName, int pid, Throwable e) {
        StringBuilder message = new StringBuilder();
        message.append("FATAL EXCEPTION: ").append(threadName).append("\n");
        if (processName != null) {
            message.append("Process: ").append(processName).append(", ");
        }
        message.append("PID: ").append(pid);
        RuntimeInit.Clog_e(TAG, message.toString(), e);
    }

    public static void preForkInit() {
        RuntimeInit.enableDdms();
        MimeMap.setDefaultSupplier(DefaultMimeMapFactory::create);
    }

    @UnsupportedAppUsage
    protected static void commonInit() {
        LoggingHandler loggingHandler = new LoggingHandler();
        RuntimeHooks.setUncaughtExceptionPreHandler(loggingHandler);
        Thread.setDefaultUncaughtExceptionHandler(new KillApplicationHandler(loggingHandler));
        RuntimeHooks.setTimeZoneIdSupplier(() -> SystemProperties.get("persist.sys.timezone"));
        LogManager.getLogManager().reset();
        new AndroidConfig();
        String userAgent = RuntimeInit.getDefaultUserAgent();
        System.setProperty("http.agent", userAgent);
        TrafficStats.attachSocketTagger();
        initialized = true;
    }

    private static String getDefaultUserAgent() {
        String id2;
        String model;
        StringBuilder result = new StringBuilder(64);
        result.append("Dalvik/");
        result.append(System.getProperty("java.vm.version"));
        result.append(" (Linux; U; Android ");
        String version = _Original_Build.VERSION.RELEASE_OR_CODENAME;
        result.append(version.length() > 0 ? version : "1.0");
        if ("REL".equals(_Original_Build.VERSION.CODENAME) && (model = _Original_Build.MODEL).length() > 0) {
            result.append("; ");
            result.append(model);
        }
        if ((id2 = _Original_Build.ID).length() > 0) {
            result.append(" Build/");
            result.append(id2);
        }
        result.append(")");
        return result.toString();
    }

    protected static Runnable findStaticMain(String className, String[] argv, ClassLoader classLoader) {
        Method m;
        Class<?> cl;
        try {
            cl = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Missing class when invoking static main " + className, ex);
        }
        try {
            m = cl.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Missing static main on " + className, ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException("Problem getting static main on " + className, ex);
        }
        int modifiers = m.getModifiers();
        if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new RuntimeException("Main method is not public and static on " + className);
        }
        return new MethodAndArgsCaller(m, argv);
    }

    @UnsupportedAppUsage
    public static void main(String[] argv) {
        RuntimeInit.preForkInit();
        if (argv.length == 2 && argv[1].equals("application")) {
            RuntimeInit.redirectLogStreams();
        }
        RuntimeInit.commonInit();
        RuntimeInit.nativeFinishInit();
    }

    protected static Runnable applicationInit(int targetSdkVersion, long[] disabledCompatChanges, String[] argv, ClassLoader classLoader) {
        RuntimeInit.nativeSetExitWithoutCleanup(true);
        VMRuntime.getRuntime().setTargetSdkVersion(targetSdkVersion);
        VMRuntime.getRuntime().setDisabledCompatChanges(disabledCompatChanges);
        Arguments args = new Arguments(argv);
        Trace.traceEnd(64L);
        return RuntimeInit.findStaticMain(args.startClass, args.startArgs, classLoader);
    }

    @RavenwoodReplace
    public static void redirectLogStreams() {
        System.out.close();
        System.setOut(new AndroidPrintStream(4, "System.out"));
        System.err.close();
        System.setErr(new AndroidPrintStream(5, "System.err"));
    }

    public static void redirectLogStreams$ravenwood() {
        if (sOut$ravenwood != null && sErr$ravenwood != null) {
            return;
        }
        Log.isLoggable("X", 2);
        if (sOut$ravenwood == null) {
            sOut$ravenwood = System.out;
            System.setOut(new AndroidPrintStream(4, "System.out"));
        }
        if (sErr$ravenwood == null) {
            sErr$ravenwood = System.err;
            System.setErr(new AndroidPrintStream(5, "System.err"));
        }
    }

    @RavenwoodReplace
    public static void wtf(String tag, Throwable t, boolean system) {
        block7: {
            try {
                boolean exit = false;
                IActivityManager am = ActivityManager.getService();
                if (am != null) {
                    exit = am.handleApplicationWtf(mApplicationObject, tag, system, new ApplicationErrorReport.ParcelableCrashInfo(t), Process.myPid());
                } else {
                    ApplicationWtfHandler handler = sDefaultApplicationWtfHandler;
                    if (handler != null) {
                        exit = handler.handleApplicationWtf(mApplicationObject, tag, system, new ApplicationErrorReport.ParcelableCrashInfo(t), Process.myPid());
                    } else {
                        Slog.e(TAG, "Original WTF:", t);
                    }
                }
                if (exit) {
                    Process.killProcess(Process.myPid());
                    System.exit(10);
                }
            }
            catch (Throwable t2) {
                if (t2 instanceof DeadObjectException) break block7;
                Slog.e(TAG, "Error reporting WTF", t2);
                Slog.e(TAG, "Original WTF:", t);
            }
        }
    }

    public static void wtf$ravenwood(String tag, Throwable t, boolean system) {
    }

    public static void setDefaultApplicationWtfHandler(ApplicationWtfHandler handler) {
        sDefaultApplicationWtfHandler = handler;
    }

    public static void setApplicationObject(IBinder app) {
        mApplicationObject = app;
    }

    @UnsupportedAppUsage
    public static IBinder getApplicationObject() {
        return mApplicationObject;
    }

    private static void enableDdms() {
        DdmRegister.registerHandlers();
    }

    static {
        mCrashing = false;
    }

    private static class LoggingHandler
    implements Thread.UncaughtExceptionHandler {
        public volatile boolean mTriggered = false;

        private LoggingHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.mTriggered = true;
            if (mCrashing) {
                return;
            }
            if (mApplicationObject == null && 1000 == Process.myUid()) {
                RuntimeInit.Clog_e(RuntimeInit.TAG, "*** FATAL EXCEPTION IN SYSTEM PROCESS: " + t.getName(), e);
                mCrashCount = SystemProperties.getInt(RuntimeInit.SYSPROP_CRASH_COUNT, 0) + 1;
                SystemProperties.set(RuntimeInit.SYSPROP_CRASH_COUNT, String.valueOf(mCrashCount));
            } else {
                RuntimeInit.logUncaught(t.getName(), ActivityThread.currentProcessName(), Process.myPid(), e);
            }
        }
    }

    private static class KillApplicationHandler
    implements Thread.UncaughtExceptionHandler {
        private final LoggingHandler mLoggingHandler;

        public KillApplicationHandler(LoggingHandler loggingHandler) {
            this.mLoggingHandler = Objects.requireNonNull(loggingHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            try {
                this.ensureLogging(t, e);
                if (mCrashing) {
                    return;
                }
                mCrashing = true;
                if (ActivityThread.currentActivityThread() != null) {
                    ActivityThread.currentActivityThread().stopProfiling();
                }
                ActivityManager.getService().handleApplicationCrash(mApplicationObject, new ApplicationErrorReport.ParcelableCrashInfo(e));
            }
            catch (Throwable t2) {
                if (t2 instanceof DeadObjectException) {
                } else {
                    try {
                        RuntimeInit.Clog_e(RuntimeInit.TAG, "Couldn't report crash. Here's the crash:", e);
                        RuntimeInit.Clog_e(RuntimeInit.TAG, "Error reporting crash. Here's the error:", t2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            finally {
                Process.killProcess(Process.myPid());
                System.exit(10);
            }
        }

        private void ensureLogging(Thread t, Throwable e) {
            if (!this.mLoggingHandler.mTriggered) {
                try {
                    this.mLoggingHandler.uncaughtException(t, e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    static class MethodAndArgsCaller
    implements Runnable {
        private final Method mMethod;
        private final String[] mArgs;

        public MethodAndArgsCaller(Method method, String[] args) {
            this.mMethod = method;
            this.mArgs = args;
        }

        @Override
        public void run() {
            try {
                this.mMethod.invoke(null, new Object[]{this.mArgs});
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(ex);
            }
        }
    }

    static class Arguments {
        String startClass;
        String[] startArgs;

        Arguments(String[] args) throws IllegalArgumentException {
            this.parseArgs(args);
        }

        private void parseArgs(String[] args) throws IllegalArgumentException {
            int curArg;
            for (curArg = 0; curArg < args.length; ++curArg) {
                String arg = args[curArg];
                if (arg.equals("--")) {
                    ++curArg;
                    break;
                }
                if (!arg.startsWith("--")) break;
            }
            if (curArg == args.length) {
                throw new IllegalArgumentException("Missing classname argument to RuntimeInit!");
            }
            this.startClass = args[curArg++];
            this.startArgs = new String[args.length - curArg];
            System.arraycopy(args, curArg, this.startArgs, 0, this.startArgs.length);
        }
    }

    public static interface ApplicationWtfHandler {
        public boolean handleApplicationWtf(IBinder var1, String var2, boolean var3, ApplicationErrorReport.ParcelableCrashInfo var4, int var5);
    }
}

